---
name: financial-product-blueprint
description: Template for packaging financial products with pricing, underwriting,
  and compliance details.
---

# Financial Product Blueprint Skill

## When to Use
- Launching new lending, payments, wealth, or insurance offerings.
- Equipping go-to-market teams with accurate pricing, disclosures, and eligibility criteria.
- Coordinating product, legal, and RevOps when offerings change.

## Framework
1. **Product Overview** – features, eligibility, underwriting policies, risk factors.
2. **Pricing & Incentives** – rate table, fees, promotional offers, guardrails.
3. **Compliance Layer** – required disclosures, consent flows, record-keeping requirements.
4. **Persona Alignment** – messaging pillars, objections, proof points per persona/segment.
5. **Operational Hooks** – systems, workflows, SLA commitments, measurement plan.

## Templates
- Product fact sheet with pricing scenarios and disclosures.
- Rate card + incentive tracker with approval fields.
- Enablement pack outline (FAQ, objection handling, ROI calculator).

## Tips
- Tie blueprint fields to CRM/CPQ fields to keep pricing + disclosures in sync.
- Version control is critical; stamp valid-from/expiration dates.
- Pair with `build-product-go-to-market` for automated briefing creation.

---
