---
name: patient-journey-mapping
description: Framework for documenting compliant patient journeys with touchpoints,
  consent, and escalation paths.
---

# Patient Journey Mapping Skill

## When to Use
- Designing education, onboarding, or adherence programs for patients/caregivers.
- Aligning cross-functional teams on touchpoints, responsibilities, and data handling.
- Preparing regulatory reviews that require end-to-end journey documentation.

## Framework
1. **Persona Canvas** – demographics, condition, motivators, fears, accessibility needs.
2. **Journey Phases** – awareness, consideration, onboarding, adherence, advocacy with goals + KPIs.
3. **Touchpoint Inventory** – channel, owner, content theme, consent requirements, escalation notes.
4. **Data & Consent Layer** – data collected per touchpoint, retention policy, opt-out mechanism.
5. **Monitoring & Feedback** – metrics, VOC loops, safety/adverse event reporting flows.

## Templates
- Journey map worksheet (phase, touchpoint, message, KPI, compliance notes).
- Consent + data handling checklist per touchpoint.
- Escalation tree for medical, legal, or support interventions.

## Tips
- Co-create journeys with clinical + legal reviewers early to reduce rework.
- Include accessibility guidelines (WCAG, language support) in each touchpoint.
- Pair with `orchestrate-patient-journey` for automated journey blueprints.

---
