---
name: nurture-testing
description: Use when planning, executing, and logging nurture experiments and regression
  tests.
---

# Nurture Testing & QA Skill

## When to Use
- Running experiments (subject lines, timing, offers, personalization) in nurture flows.
- Performing regression tests before go-live or updates.
- Documenting QA evidence for compliance/audits.

## Framework
1. **Test Design** – hypothesis, variable, control, variant, KPI, sample size, duration.
2. **QA Checklist** – links, tokens, segmentation, tracking, device/browser coverage, accessibility.
3. **Evidence Logging** – screenshots, seed inbox captures, MAP logs, CRM task verification.
4. **Significance & Rollout** – evaluation method (frequentist/Bayesian), rollout criteria, holdback rules.
5. **Regression Cadence** – schedule for periodic audits, triggered when assets/tokens change.

## Templates
- Experiment brief + tracker.
- QA matrix (scenario, expected result, status, owner).
- Evidence archive folder structure.

## Tips
- Always include control groups or holdouts for long-running nurtures.
- Automate reminders to re-run QA after major MAP/CRM updates.
- Pair with `personalization-logic` and `marketing-ops-partner` to catch edge cases early.

---
