---
name: reward-ops
description: Use to run day-to-day loyalty reward catalog management and fulfillment.
---

# Reward Operations Skill

## When to Use
- Launching or refreshing reward catalogs.
- Coordinating fulfillment vendors and automation.
- Auditing operational readiness before major loyalty pushes.

## Framework
1. **Catalog Governance** – metadata (SKU, cost, eligibility, expiry), vendor SLAs, localization.
2. **Fulfillment Automation** – points issuance, redemption logic, webhooks, notifications, support flows.
3. **Risk & Compliance** – tax reporting, export restrictions, fraud detection, audit logs.
4. **Support Runbooks** – escalation paths, refund policies, communication templates.
5. **Continuous Improvement** – performance reviews, vendor scorecards, refresh cadence.

## Templates
- Reward catalog spreadsheet with governance fields.
- Fulfillment flowchart (trigger → system → action → SLA).
- Incident log + RCA template.

## Tips
- Maintain sandbox environments to test new rewards end-to-end.
- Pair with finance/legal reviews for new reward types.
- Keep member communications consistent by storing approved macros.

---
