---
name: market-scenario-modeler
description: Toolkit for building TAM/SAM/SOM models, sensitivity analyses, and narrative-ready
  visuals.
---

# Market Scenario Modeler Skill

## When to Use
- Translating research findings into financial models and strategic scenarios.
- Stress-testing revenue or adoption assumptions for planning cycles.
- Packaging insights for finance, product, and executive stakeholders.

## Framework
1. **Assumption Library** – document data sources, CAGR, penetration, pricing, channel mix.
2. **Scenario Matrix** – base, upside, downside cases with drivers (pricing, win rate, expansion, macro).
3. **Sensitivity Analysis** – tornado charts, Monte Carlo snippets, or sliders for key variables.
4. **Visualization Layer** – waterfall, area, and heat maps tying numbers to narratives.
5. **Decision Hooks** – highlight trigger points, required investments, and guardrails.

## Templates
- Spreadsheet/notebook skeleton with clearly named inputs/outputs.
- Slide templates for TAM/SAM/SOM, share shifts, and investment asks.
- One-pager summary translating scenarios into actions and risks.

## Tips
- Keep assumptions auditable with source links and timestamps.
- Align with finance on currency, inflation, and exchange assumptions before publishing.
- Pair with `run-market-landscape-study` for turnkey modeling assets.

---
