---
name: attribution
description: Use to define measurement, data sharing, and ROI reporting for joint
  campaigns.
---

# Co-marketing Attribution Playbook Skill

## When to Use
- Planning measurement strategy for joint campaigns or events.
- Reconciling attribution discrepancies between partner analytics stacks.
- Preparing executive or partner reports on shared pipeline/revenue impact.

## Framework
1. **Taxonomy Alignment** – agree on UTM structure, campaign IDs, stages, and conversion definitions.
2. **Data Exchange** – determine cadence, format, security requirements, and normalization rules.
3. **Attribution Models** – select methods (first/last/multi-touch, split attribution, weighted models) and document assumptions.
4. **Governance** – define owners for metric updates, dispute resolution, and audit trails.
5. **Storytelling** – package dashboards and narratives for stakeholders, highlighting joint impact and next steps.

## Templates
- Attribution worksheet (source → partner → funnel stage → revenue).
- Data sharing checklist (fields, format, frequency, security).
- Reporting deck outline (KPIs, insights, actions).

## Tips
- Run attribution dry-runs before launch to catch data gaps.
- Include qualitative context (partner reach, brand lift) alongside quantitative metrics.
- Pair with `track-source` command to keep reports consistent across cycles.

---
