---
name: partner-ecosystem-map
description: Visualization toolkit for mapping partner landscape, coverage, and priorities.
---

# Partner Ecosystem Map Skill

## When to Use
- Planning partner strategy, territorial coverage, or whitespace analysis.
- Presenting ecosystem status to executives or cross-functional stakeholders.
- Tracking progress against partner recruitment and ramp goals.

## Framework
1. **Segmentation Layer** – partner type, region, vertical, solution fit, maturity.
2. **Value Layer** – pipeline contribution, ARR influenced, co-sell velocity, joint wins.
3. **Health Layer** – certification status, enablement completion, NPS, engagement cadence.
4. **Gaps & Targets** – highlight priority segments needing recruits or investment.
5. **Narrative Hooks** – pair visuals with summary insights, risks, and next plays.

## Templates
- Ecosystem matrix with rows (partner type) × columns (value/health metrics).
- Geo overlay map for territory coverage vs whitespace.
- Executive summary slide linking visuals to investment requests.

## Tips
- Keep visuals updated monthly so leadership trusts the snapshot.
- Link each gap to a specific recruiting or enablement initiative.
- Pair with `design-partner-ecosystem` for streamlined planning packages.

---
