---
name: variance-analysis
description: Use to attribute forecast vs actual deltas and recommend remediation
  actions.
---

# Revenue Variance Analysis Skill

## When to Use
- Preparing forecast reviews or board updates that require variance explanations.
- Investigating misses/exceeds across segments, products, or channels.
- Prioritizing remediation plays tied to specific variance drivers.

## Framework
1. **Driver Taxonomy** – classify deltas into volume, conversion, price/mix, churn, expansion, currency.
2. **Attribution Logic** – define formulas for each driver and maintain consistent baselines.
3. **Root Cause Layer** – connect drivers to operational issues (pipeline quality, capacity, enablement, macro).
4. **Action Mapping** – translate each root cause into specific plays with owners and expected impact.
5. **Feedback Loop** – update forecasting assumptions once variance is understood.

## Templates
- Variance waterfall chart setup instructions.
- Driver worksheet (metric → delta → driver → root cause → owner → due date).
- Remediation tracker with status and forecast impact.

## Tips
- Keep a glossary so stakeholders interpret drivers consistently.
- Combine quantitative attribution with qualitative context from GTM leaders.
- Feed learnings back to `forecast-modeling` to tighten assumptions next cycle.

---
