---
name: quota-health
description: Use to analyze quota distribution, attainment fairness, and productivity
  signals.
---

# Quota Health Review Skill

## When to Use
- During annual planning to align quotas with territory potential.
- Mid-year to diagnose underperformance risks or over-assignment.
- Before launching compensation plan changes or SPIFs.

## Framework
1. **Data Collection** – pull attainment, pipeline, coverage, and territory metrics by rep/segment.
2. **Fairness Analysis** – compute attainment distribution, Gini coefficient, and coverage ratios.
3. **Signal Review** – identify chronic over/under assignments, ramp issues, or constrainted territories.
4. **Recommendation Engine** – suggest quota rebalancing, enablement, or hiring adjustments.
5. **Governance** – log proposed changes, approval needs, and communication strategy.

## Templates
- Quota health dashboard (rep-level KPIs, quartiles, recommendations).
- CRO briefing outline with risks/opportunities.
- Quota adjustment request form with approvals.

## Tips
- Pair with `territory-optimization` outputs to ensure coverage and quota stay in sync.
- Normalize attainment for ramping reps to avoid skewed fairness scores.
- Keep change logs auditable for finance and legal.

---
