---
name: crm-hygiene
description: Use to enforce stage definitions, next-step requirements, and data completeness
  across the pipeline.
---

# CRM Hygiene Playbook Skill

## When to Use
- Preparing for pipeline inspections or forecast calls.
- Auditing data quality before exec reviews or board decks.
- Coaching reps on consistent CRM updates.

## Framework
1. **Stage Definitions** – document entry/exit criteria and mandatory fields for each stage.
2. **Data Completeness** – ensure next steps, close dates, contacts, and products are filled.
3. **Aging Thresholds** – define acceptable days-in-stage and automatic escalation triggers.
4. **Exception Handling** – outline how to request overrides or re-open closed deals.
5. **Monitoring** – schedule hygiene dashboards + alerts for missing data.

## Templates
- Stage checklist (fields + approvers per stage).
- Hygiene scorecard for reps/managers.
- Escalation request form for data overrides.

## Tips
- Automate reminders for missing next steps or overdue close dates.
- Pair with forecasting enablement to keep assumptions grounded.
- Share hygiene scores transparently to drive accountability.

---
