---
name: cold-outreach
description: Master cold email, LinkedIn, and first-touch prospect outreach. Use when crafting outbound sequences, social touches, or follow-ups that must earn fast responses.
---

# Cold Outreach Mastery

## When to Use

- Building outbound sequences for new personas or segments
- Personalizing cold email / LinkedIn outreach at scale
- Diagnosing low open or reply rates in existing sequences
- Designing follow-up cadences for SDR/XDR or founder-led sales

## Framework
1. **Core Principles** – pattern interruption, value before ask, authentic personalization, mobile-first formatting, single CTA.
2. **SPARK Flow** – Subject hook → Personalized opening → Agitate problem → Relevant value → Kick-off CTA.
3. **Channel Mix** – email templates + LinkedIn touches + call follow-ups working together.
4. **Cadence Design** – 3-touch follow-up over 14 days with new insights each step.
5. **Experimentation** – test subject/openers/value props/CTAs/send times; watch ≥30% opens, ≥10% replies.

## Templates
- Subject line bank ("Quick question about [initiative]", "Noticed you're hiring [role]", etc.)
- Email templates (Observation & Insight, Problem/Solution, Referral) plus LinkedIn connection + post-accept scripts.
- Personalization trigger sheet (company + individual signals) and follow-up schedule checklist.
- Power phrase/reference list and industry-specific angle cheatsheets (SaaS, e-comm, financial services, healthcare).

## Tips
- Anchor every opener on a real trigger (funding, hiring, post) and keep lines <60 chars for mobile readability.
- Offer a resource or benchmark before requesting time; it increases reply rate.
- Log A/B test results weekly to evolve templates, and share top-performing subject lines with the team.
- Keep all templates in a shared library with progressive disclosure to avoid template fatigue.

---

*Progressive disclosure: load full templates/examples only when actively generating outreach copy.*
