---
name: objection-handling
description: Use when preparing responses to prospect objections during outbound, discovery, or follow-up conversations.
---

# Objection Handling Skill

## When to Use
- Prospects push back on timing, budget, priority, or vendor choice.
- SDRs/AEs need concise, value-first rebuttals for email, phone, or social.
- Enablement teams are building battlecards and talk tracks.

## Framework
1. **LACE** – Listen, Acknowledge, Clarify, Educate for every objection.
2. **Diagnosis** – identify category (budget, timing, competition, info) and root cause.
3. **Response Construction** – combine empathy statement + proof + CTA for next step.
4. **Channel Adaptation** – adapt scripts for email, call, social with same backbone.
5. **Feedback Loop** – log outcomes in objection tracker to refine messaging.

## Templates
- Common objection table with diagnosis + recommended responses.
- Email snippet:
```
Hi {name}, totally hear you on {objection}. Many {persona}s said the same until they saw {proof point}.

How about we {next step} so you can evaluate without interrupting your week?
```
- Call script snippets (“If {metric} improved by 15%, would it merit a closer look?”).
- Battlecard snippets and micro case studies linked per objection.

## Tips
- Mirror the exact language the prospect used before responding.
- Ask one clarifying question before presenting proof—often the real objection surfaces.
- Tailor proof to persona (finance → ROI, ops → efficiency, IT → security).
- Track objection frequency weekly to inform marketing content and enablement.

---
