---
name: publishing-process
description: Use to orchestrate approvals, QA, and go-live steps for SEO content +
  technical launches.
---

# SEO Publishing Process Skill

## When to Use
- Coordinating multi-team releases (writers, designers, web, legal).
- Ensuring SEO assets meet quality, accessibility, and analytics requirements before launch.
- Running retros after missed deadlines or publishing defects.

## Framework
1. **Pre-flight Checklist** – briefs approved, assets uploaded, localization complete, legal sign-off captured.
2. **CMS/Code QA** – metadata, schema markup, internal links, CWV budgets, responsive design.
3. **Analytics & Tracking** – UTMs, event triggers, conversion modules, A/B test configs.
4. **Launch Controls** – staging reviews, smoke tests, rollback plan, comms schedule.
5. **Post-launch Validation** – indexation check, monitoring alerts, performance baseline snapshot.

## Templates
- Publishing runbook (steps, owner, evidence link, status).
- QA checklist (content, technical, analytics, accessibility).
- Launch log capturing timestamps, environments, and approvals.

## Tips
- Timebox approvals with clear SLAs to keep calendars on track.
- Automate checklist reminders via project tools or Git hooks.
- Pair with `deploy-optimizations` to keep evidence attached to each task.

---
