---
name: distribution-analytics
description: Use when planning channel distribution and measuring video performance.
---

# Video Distribution & Analytics Skill

## When to Use
- Planning cross-channel release strategy (YouTube, LinkedIn, TikTok, paid, website).
- Optimizing promotion cadence, paid boosts, and partner amplification.
- Reporting on video engagement, conversions, and ROI.

## Framework
1. **Owned Channels** – website, blog embeds, email nurtures, product UI.
2. **Social Platforms** – channel-specific formatting (length, aspect ratio, subtitles, hooks).
3. **Paid Media** – targeting, budget allocation, creative rotation, lift studies.
4. **Partners/Community** – syndication, co-marketing, advocacy programs.
5. **Repurposing** – clips, GIFs, reels, audio snippets, transcript-based blogs.

## Analytics Stack
- **Awareness** – impressions, views, view-through rate, unique viewers.
- **Engagement** – watch time, retention curves, clicks, comments, shares.
- **Conversion** – CTA clicks, landing page visits, opportunities, revenue.
- **Attribution** – first-touch vs multi-touch analyses, cohort performance.

## Templates
- Channel playbook (requirements, posting schedule, CTA guidance).
- Dashboard schema (metrics, source, refresh cadence).
- Optimization tracker (hypothesis, test, result, next step).

## Tips
- Localize thumbnails and captions per channel.
- Use UTM conventions and vanity URLs to attribute conversions.
- Monitor audience retention graphs to inform editing decisions.

---
