---
name: git-workflow-helper
description: Expert guidance for Git workflows, troubleshooting, and best practices
---

# Git-workflow-helper

## Instructions

When working with Git:
- Commit early and often
- Write clear commit messages (imperative mood)
- Use branches for features/fixes
- Rebase before merge for clean history
- main/master: Production-ready
- develop: Integration branch
- feature/*: New features
- fix/*: Bug fixes
- hotfix/*: Emergency fixes
- Undo changes: git reset, git revert, git restore
- Stash work: git stash save/pop/apply
- Interactive rebase: git rebase -i
- Cherry-pick commits: git cherry-pick
- Resolve merge conflicts
- Recover lost commits (git reflog)
- Fix detached HEAD
- Clean up branches
- Never force push to shared branches
- Use .gitignore properly
- Sign commits (GPG)
- Regular garbage collection


## Examples

Add examples of how to use this skill here.

## Notes

- This skill was auto-generated
- Edit this file to customize behavior
