---
name: json-config-helper
description: Validate, format, and work with JSON configuration files
---

# Json-config-helper

## Instructions

When working with JSON files:
- Validate syntax with jq
- Pretty-print with jq '.'
- Minify with jq -c
- Sort keys with jq -S
- Extract values: jq '.key.subkey'
- Filter arrays: jq '.[] | select(.name == "value")'
- Map operations: jq 'map(.field)'
- package.json (Node.js)
- .mcp.json (MCP servers)
- .vscode settings
- Docker configs
- jq for command-line processing
- Suggest schema validation tools
- Provide corrected versions
- Find syntax errors (missing commas, quotes)
- Validate against JSON Schema
- Handle encoding issues


## Examples

Add examples of how to use this skill here.

## Notes

- This skill was auto-generated
- Edit this file to customize behavior
