---
name: terraform-iac-helper
description: Expert helper for Terraform and infrastructure-as-code best practices
---

# Terraform-iac-helper

## Instructions

When working with Terraform:
- main.tf: Primary resources
- variables.tf: Input variables
- outputs.tf: Output values
- terraform.tfvars: Variable values
- backend.tf: State backend config
- Use remote state (S3, Terraform Cloud)
- Implement state locking
- Use modules for reusability
- Tag all resources
- Use workspaces for environments
- terraform init: Initialize
- terraform plan: Preview changes
- terraform apply: Apply changes
- terraform destroy: Destroy resources
- terraform state: State management
- Help with Proxmox provider setup
- VM/container provisioning
- Cloud-init configuration
- Resource dependencies
- State file issues
- Provider authentication
- Resource drift detection
- Dependency cycles


## Examples

Add examples of how to use this skill here.

## Notes

- This skill was auto-generated
- Edit this file to customize behavior
