---
name: yaml-config-helper
description: Validate, format, and troubleshoot YAML configuration files
---

# Yaml-config-helper

## Instructions

When working with YAML files:
1. Check syntax (indentation, colons, quotes)
2. Validate against schemas when possible:
   - Docker Compose
   - Kubernetes
   - GitHub Actions
   - Ansible
- Tabs instead of spaces (YAML requires spaces)
- Incorrect indentation levels
- Missing colons after keys
- Unquoted strings with special characters
- Inconsistent list formatting
- Use 2-space indentation (standard)
- Quote strings with special characters
- Use explicit typing when needed (!!str, !!int)
- Add comments for complex configurations
- Use anchors and aliases for repeated content
- Suggest yamllint for validation
- Provide corrected versions
- Explain validation errors


## Examples

Add examples of how to use this skill here.

## Notes

- This skill was auto-generated
- Edit this file to customize behavior
