# FastAPI Skill

**Status**: Production Ready
**Last Updated**: December 2025

## Auto-Trigger Keywords

### Primary
- FastAPI
- Python API
- Pydantic
- uvicorn

### Secondary
- async Python
- SQLAlchemy async
- Python REST API
- JWT Python
- python-jose
- ASGI
- Starlette

### Error-Based
- "422 Unprocessable Entity"
- "CORS policy"
- "Field required"
- "validation error"
- "async blocking"

## What This Skill Does

Provides production-tested patterns for building Python APIs with FastAPI:

- **Project Setup**: uv-based project initialization
- **Structure**: Domain-based organization for maintainability
- **Validation**: Pydantic v2 schemas with proper constraints
- **Database**: SQLAlchemy 2.0 async with proper session handling
- **Authentication**: JWT with OAuth2PasswordBearer
- **Testing**: pytest with async client
- **Deployment**: Uvicorn/Gunicorn patterns

## Known Issues Prevented

| Issue | Symptom | Prevention |
|-------|---------|------------|
| Blocking async | All requests hang | Use `asyncio.sleep()` not `time.sleep()` |
| 422 errors | Validation failures | Proper Pydantic schema matching |
| CORS blocked | Browser errors | CORSMiddleware configuration |
| Optional fields required | "Field required" error | Use `str \| None = None` pattern |
| Circular imports | Import errors | Domain-based structure |

## When to Use

- Creating new Python APIs
- Setting up FastAPI projects from scratch
- Implementing JWT authentication
- Configuring async SQLAlchemy
- Debugging validation or CORS errors

## When NOT to Use

- Simple scripts (overkill)
- Flask projects (use flask skill instead)
- Synchronous-only requirements
- Django projects

## Version Info

| Package | Version |
|---------|---------|
| FastAPI | 0.123.2 |
| Pydantic | 2.11.7 |
| SQLAlchemy | 2.0.30 |
| Uvicorn | 0.35.0 |
| python-jose | 3.3.0 |

## Quick Start

```bash
uv init my-api && cd my-api
uv add fastapi[standard] sqlalchemy[asyncio] aiosqlite
uv run fastapi dev src/main.py
```

## Resources

- `SKILL.md` - Full documentation
- `templates/` - Ready-to-use project files
