# Consultation Note Template

**Patient Name:** [Last, First]  
**Medical Record Number:** [MRN]  
**Date of Birth:** [MM/DD/YYYY]  
**Age/Sex:** [years, M/F]

**Consultation Date:** [MM/DD/YYYY]  
**Consultation Time:** [HH:MM]  
**Location:** [Floor, Room number]

**Requesting Service:** [Primary team]  
**Requesting Physician:** [Name]  
**Consulting Service:** [Cardiology, Nephrology, etc.]  
**Consulting Physician:** [Name and credentials]

---

## Reason for Consultation

[Specific clinical question or reason for consultation]

Example: "Please evaluate and manage acute kidney injury in setting of heart failure exacerbation."

---

## History of Present Illness (Focused on Consultation Question)

[Relevant history focused on the consultation question]

[Patient Name] is a [age]-year-old [sex] with a history of [relevant conditions] currently admitted to [service] for [admission diagnosis] who is being consulted for [specific issue].

[Chronological narrative relevant to consultation question]

**Timeline of Current Issue:**
- [Key events leading to consultation]
- [Current status]
- [Treatments tried]

---

## Relevant Past Medical History

1. [Condition relevant to consultation]
2. [Additional relevant conditions]

[Only include history pertinent to consultation question]

---

## Current Medications

[List medications relevant to consultation question]

| Medication | Dose | Route | Frequency | Relevant to: |
|------------|------|-------|-----------|--------------|
| [Drug] | [mg] | [route] | [freq] | [Why relevant] |

---

## Allergies

| Allergen | Reaction |
|----------|----------|
| [Drug/substance] | [Reaction] |

---

## Relevant Social/Family History

[Only include if pertinent to consultation]

---

## Review of Systems (Focused)

[Focus on systems relevant to consultation question]

**[Relevant system]:** [Findings]  
**[Additional relevant systems]:** [Findings]

---

## Physical Examination

**Vital Signs:**
- Temperature: _____ °F
- Blood Pressure: _____/_____ mmHg
- Heart Rate: _____ bpm
- Respiratory Rate: _____ breaths/min
- Oxygen Saturation: _____% on [O2 status]
- Weight: _____ kg (if relevant)

**General:**  
[Overall appearance, distress level]

**[Focused Examination Relevant to Consultation]:**

**Example for Cardiology Consult:**
- **Cardiovascular:**
  - JVP: [cm H2O]
  - PMI: [location]
  - Heart sounds: [S1, S2, murmurs, gallops, rubs]
  - Peripheral pulses: [quality]
  - Edema: [location and severity]

**Example for Pulmonary Consult:**
- **Pulmonary:**
  - Respiratory effort: [description]
  - Auscultation: [breath sounds, wheezes, crackles]
  - Percussion: [findings]

[Include other relevant systems, may abbreviate or defer non-pertinent systems]

---

## Pertinent Laboratory and Imaging Data

**Labs ([Date]):**

[Include only labs relevant to consultation]

| Test | Result | Reference Range | Trend |
|------|--------|----------------|-------|
| [Relevant lab] | [Value] | [Range] | [↑/↓/→] |

**Imaging/Diagnostics:**

**[Study] ([Date]):** [Relevant findings]

**ECG ([Date]):** [Relevant findings]

**Other Studies:** [Relevant results]

---

## Assessment

**Consultant's Assessment of [Specific Problem]:**

[Detailed assessment of the consultation question]

**Differential Diagnosis:**
1. [Most likely diagnosis] - [supporting evidence]
2. [Alternative diagnosis] - [evidence for/against]
3. [Additional considerations]

**Severity/Acuity:** [Assessment of severity]

**Contributing Factors:** [What is contributing to the problem]

**Prognosis:** [Short-term and long-term outlook]

---

## Recommendations

**[Problem Being Addressed]:**

**Diagnostic Recommendations:**
1. [Specific test] - [Rationale]
2. [Additional studies] - [Why needed]

**Therapeutic Recommendations:**
1. **[Intervention/Medication]:**
   - [Specific dose, route, frequency]
   - [Duration]
   - [Rationale]
   - [Monitoring parameters]

2. **[Additional treatments]**

3. **[Procedures if recommended]:**
   - [Procedure name]
   - [Indication]
   - [Timing]

**Monitoring Recommendations:**
- [What to monitor]
- [How often]
- [Target parameters]

**Follow-up Recommendations:**
- [ ] Will follow along as consultant during hospitalization
- [ ] Recommend follow-up in [Specialty] clinic in [timeframe]
- [ ] Recommend re-consultation if [specific circumstances]
- [ ] No further consultation needed unless [conditions]

**Additional Recommendations:**
- [Lifestyle modifications]
- [Patient education points]
- [Precautions]

**Recommendations Summary for Primary Team:**
[Concise bulleted list of key recommendations that can be quickly reviewed]
1. [Action item 1]
2. [Action item 2]
3. [Action item 3]

---

## Consultantdiscussion with Primary Team

**Discussed with:** [Name, role]  
**Date/Time:** [MM/DD/YYYY at HH:MM]  
**Topics discussed:** [Key points discussed]  
**Plan agreed upon:** [Agreement or modifications]

---

## Follow-up Plan

**Consultant will:**
- [ ] Round daily until [condition met or discharge]
- [ ] Re-evaluate in [X] days
- [ ] Available for questions or changes in clinical status
- [ ] Recommend outpatient follow-up in [timeframe]

**Primary team to:**
- [ ] Implement above recommendations
- [ ] Notify consultant if [specific circumstances]
- [ ] Monitor [specific parameters]

---

## Signature

**Consultant:** [Name, MD/DO, credentials]  
**Service:** [Consulting service]  
**Date/Time:** [MM/DD/YYYY at HH:MM]  
**Pager/Contact:** [Number]  
**Signature:** ____________________

**Co-signature (if fellow or resident):**  
**Attending:** [Name, credentials]  
**Date/Time:** [MM/DD/YYYY at HH:MM]  
**Signature:** ____________________

---

## Template Notes

**Key Principles for Consultation Notes:**

1. **Answer the question:** Directly address the specific consultation request
2. **Be focused:** Include only information relevant to the consultation
3. **Be specific:** Provide clear, actionable recommendations
4. **Be concise:** Respect primary team's time
5. **Be available:** Make follow-up plan clear

**Common Consultation Types:**

**Cardiology:**
- Pre-operative risk assessment
- Arrhythmia management
- Heart failure management
- Chest pain evaluation

**Nephrology:**
- Acute kidney injury
- Chronic kidney disease management
- Electrolyte abnormalities
- Dialysis initiation/management

**Infectious Disease:**
- Antibiotic selection
- Fever of unknown origin
- Complex infections
- HIV management

**Endocrinology:**
- Diabetes management
- Thyroid disorders
- Adrenal insufficiency
- Calcium disorders

**Psychiatry:**
- Capacity assessment
- Depression/anxiety management
- Agitation management
- Substance withdrawal

**Pain Management:**
- Chronic pain consultation
- Post-operative pain control
- Cancer pain management

**Palliative Care:**
- Goals of care discussion
- Symptom management
- End-of-life care planning

**Tips for Effective Consultations:**

- Call the referring provider before seeing patient to clarify question
- Introduce yourself to patient and explain your role
- Review chart thoroughly before examination
- Be respectful of primary team's care
- Make specific recommendations, not vague suggestions
- Document same day as consultation
- Communicate recommendations verbally when appropriate
- Be available for questions
- Follow up consistently if ongoing consultation


