# Peer Review Standards for Clinical Manuscripts

## Overview of Clinical Manuscript Peer Review

### Purpose

Peer review ensures that clinical manuscripts meet standards for scientific rigor, ethical conduct, and clear communication before publication.

**Objectives:**
- Assess scientific validity and methodology
- Evaluate clinical significance
- Verify ethical compliance
- Ensure clarity and completeness
- Improve manuscript quality

**Types of peer review:**
- Single-blind (reviewer knows author, author doesn't know reviewer)
- Double-blind (both parties anonymous)
- Open peer review (both parties known)
- Post-publication peer review

### Reviewer Responsibilities

**Accept reviews only when:**
- Qualified in the subject area
- No conflicts of interest
- Adequate time available (typically 2-3 weeks)
- Can provide constructive, unbiased evaluation

**Maintain confidentiality:**
- Do not share manuscript content
- Do not use information for personal advantage
- Do not involve others without editor permission

**Provide timely review:**
- Complete within requested timeframe
- Notify editor promptly if unable to complete

## Case Report Review Criteria

### CARE Guideline Compliance

**Verify manuscript includes:**
- [ ] Title identifies it as case report
- [ ] Keywords provided (2-5)
- [ ] Structured or unstructured abstract
- [ ] Introduction explaining why case is novel
- [ ] Patient information (de-identified)
- [ ] Clinical findings
- [ ] Timeline of events
- [ ] Diagnostic assessment
- [ ] Therapeutic interventions
- [ ] Follow-up and outcomes
- [ ] Discussion with literature review
- [ ] Patient perspective (if applicable)
- [ ] Informed consent statement

### Novelty and Significance

**Assess:**
- Is this case truly novel or does it add to medical knowledge?
- What makes this case worth reporting?
- Is the condition rare or presentation unusual?
- Does it challenge existing knowledge?
- Are there clinical lessons that can be generalized?

**Red flags:**
- Common presentation of common condition
- Single case without unique features
- Overgeneralization from single case
- Lack of literature review showing novelty

### Privacy and Ethical Considerations

**Verify:**
- Informed consent obtained and documented
- Patient adequately de-identified (18 HIPAA identifiers removed)
- No identifiable images without explicit consent
- Dates removed or approximated
- Geographic information limited to state/country
- Age appropriate (exact age or range)
- Institutional identifiers removed

**Ethical concerns:**
- Missing consent documentation
- Identifiable information present
- Lack of IRB approval for retrospective chart review (if applicable)
- Vulnerable populations without additional protections

### Clinical Quality

**Diagnostic process:**
- Appropriate workup for presenting symptoms
- Differential diagnosis considered
- Logical progression to final diagnosis
- Adequate documentation of findings

**Treatment:**
- Evidence-based interventions
- Rationale for treatment choices
- Alternative treatments considered
- Appropriate monitoring and follow-up

**Outcome:**
- Clear description of clinical outcome
- Follow-up duration appropriate
- Complications documented
- Long-term outcome if available

### Literature Review

**Assess:**
- Adequate search of existing literature
- Similar cases identified and discussed
- Current understanding of condition reviewed
- Case appropriately contextualized
- References current and relevant
- Comparison to prior cases

### Writing Quality

**Structure:**
- Logical flow and organization
- CARE guideline structure followed
- Clear, concise writing
- Appropriate medical terminology

**Clarity:**
- Medical jargon explained
- Timeline clear and easy to follow
- Chronology of events logical
- Conclusions supported by case details

## Clinical Trial Manuscript Review Criteria

### Study Design and Methodology

**Assess:**
- Appropriate study design for research question
- Clear objectives and hypotheses
- Well-defined primary and secondary endpoints
- Adequate sample size with power calculation
- Randomization and blinding appropriate
- Control group appropriate

**Red flags:**
- Post-hoc changes to endpoints
- Underpowered study claiming equivalence
- Inappropriate statistical methods
- Lack of blinding when feasible
- Selection bias in enrollment

### CONSORT Compliance

**Verify:**
- Title identifies as randomized trial
- Structured abstract
- Trial registration number provided
- Protocol accessible
- CONSORT flow diagram included
- Baseline characteristics table
- All outcomes reported (not just significant ones)
- Adverse events reported
- Funding source disclosed
- Conflicts of interest declared

### Randomization and Allocation

**Assess:**
- Adequate sequence generation method
- Allocation concealment appropriate
- Baseline characteristics balanced
- Stratification factors specified
- Crossovers and protocol deviations documented

### Participant Flow

**Verify:**
- Number screened reported
- Exclusion reasons provided
- Number randomized clear
- Dropouts and reasons documented
- Lost to follow-up minimized and explained
- ITT and per-protocol analyses specified
- CONSORT diagram complete and accurate

### Outcome Measures

**Primary outcome:**
- Clearly defined a priori
- Clinically meaningful
- Appropriate for research question
- Measured reliably and validly
- Statistical analysis appropriate

**Secondary outcomes:**
- Pre-specified in protocol
- Analyzed appropriately
- Multiple comparison correction if needed
- Not over-interpreted if underpowered

**Exploratory outcomes:**
- Clearly labeled as exploratory or post-hoc
- Not given same weight as primary
- Hypothesis-generating, not confirmatory

### Statistical Analysis

**Assess:**
- Analysis plan specified before unblinding
- Appropriate statistical tests
- Assumptions verified (normality, etc.)
- Missing data handled appropriately
- Multiplicity adjustments when needed
- Confidence intervals provided
- Effect sizes reported

**Common issues:**
- p-hacking (selective reporting)
- Multiple testing without correction
- Inappropriate subgroup analyses
- Switching between ITT and per-protocol analyses
- Missing data ignored or improperly handled

### Safety Reporting

**Verify:**
- All adverse events reported
- Serious adverse events detailed
- Deaths fully described
- Causality assessed
- Laboratory abnormalities reported
- Discontinuations due to AEs documented

### Clinical Significance

**Assess:**
- Statistical significance vs. clinical significance
- Magnitude of effect clinically meaningful
- Number needed to treat (NNT) if applicable
- Benefit-risk ratio favorable
- Generalizability to practice
- Cost-effectiveness considerations

## Diagnostic Study Review Criteria

### STARD Guidelines (Standards for Reporting Diagnostic Accuracy Studies)

**Assess compliance:**
- Study design described
- Participant selection criteria
- Sampling method
- Data collection procedure
- Reference standard defined
- Index test described in detail
- Blinding addressed
- Flow of participants clear
- 2×2 table provided
- Diagnostic accuracy estimates

### Reference Standard

**Verify:**
- Appropriate gold standard used
- Same reference standard for all participants
- Reference standard performed regardless of index test result
- Time between index test and reference standard appropriate
- Independent interpretation of index test and reference standard

### Test Performance

**Required metrics:**
- Sensitivity and specificity
- Positive and negative predictive values (with prevalence)
- Likelihood ratios
- ROC curve and AUC (if continuous outcome)
- 95% confidence intervals for all estimates

**Consider:**
- Pre-test and post-test probabilities
- Clinical utility beyond accuracy
- Comparison to existing tests
- Cost and availability

### Spectrum and Verification Bias

**Assess:**
- Spectrum of disease severity included
- Avoiding spectrum bias (only severe cases)
- Verification bias avoided (all participants get reference standard)
- Differential verification avoided (different reference standards for different participants)

## Observational Study Review Criteria

### STROBE Guidelines (Strengthening the Reporting of Observational Studies in Epidemiology)

**For cohort, case-control, or cross-sectional studies, verify:**
- Title and abstract identify study design
- Background and rationale clear
- Objectives specified
- Study design present in methods
- Setting described
- Participants described
- Variables clearly defined
- Data sources and measurement detailed
- Bias addressed
- Study size justified
- Statistical methods described
- Results reported with effect sizes and CIs

### Exposure and Outcome Assessment

**Assess:**
- Exposure clearly defined
- Outcome clearly defined
- Measurement methods valid and reliable
- Blinding of assessors when possible
- Consistent measurement across groups
- Time relationship between exposure and outcome appropriate

### Confounding and Bias

**Verify:**
- Potential confounders identified
- Adjustment for confounders in analysis
- Residual confounding discussed
- Selection bias addressed
- Information bias considered
- Sensitivity analyses performed

### Causality

**Bradford Hill Criteria consideration:**
- Strength of association
- Consistency across studies
- Specificity
- Temporality (exposure precedes outcome)
- Biological gradient (dose-response)
- Plausibility
- Coherence with existing knowledge
- Experimental evidence
- Analogy

**Avoid:**
- Causal language for observational studies without strong evidence
- Confusing association with causation

## Systematic Review and Meta-Analysis Review Criteria

### PRISMA Guidelines

**Verify:**
- Title identifies as systematic review/meta-analysis
- Structured abstract
- Research question (PICO format)
- Protocol and registration (PROSPERO)
- Search strategy comprehensive
- Study selection process described
- Data extraction process
- Quality assessment of included studies
- Synthesis methods appropriate
- Results with forest plots
- Assessment of heterogeneity
- Publication bias assessed
- Certainty of evidence (GRADE)

### Search Strategy

**Assess:**
- Multiple databases searched
- Search terms comprehensive
- Limits and filters justified
- Gray literature considered
- Hand-searching of references
- Contact with authors for missing data
- Search reproducible

### Study Selection

**Verify:**
- Inclusion/exclusion criteria pre-specified
- Independent screening by ≥2 reviewers
- Disagreements resolved appropriately
- PRISMA flow diagram complete
- Excluded studies with reasons

### Quality Assessment

**Assess:**
- Appropriate quality assessment tool used
  - RCTs: Cochrane Risk of Bias tool
  - Observational: Newcastle-Ottawa Scale
  - Diagnostic: QUADAS-2
- Independent quality assessment
- Results of quality assessment reported
- Quality incorporated into synthesis

### Statistical Methods

**For meta-analysis:**
- Fixed vs. random effects model justified
- Heterogeneity assessed (I², Q statistic)
- Forest plot provided
- Publication bias assessed (funnel plot, Egger's test)
- Sensitivity analyses performed
- Subgroup analyses pre-specified

### GRADE Assessment

**Certainty of evidence:**
- High: Very confident in effect estimate
- Moderate: Moderately confident
- Low: Limited confidence
- Very low: Very little confidence

**Factors decreasing certainty:**
- Risk of bias
- Inconsistency
- Indirectness
- Imprecision
- Publication bias

## Manuscript Quality Assessment

### Structure and Organization

**Assess:**
- Logical flow from introduction through discussion
- Sections appropriately organized
- Figures and tables support text
- Supplementary materials appropriate

### Writing Quality

**Clarity:**
- Clear, concise language
- Jargon minimized and defined
- Abbreviations defined at first use
- Consistent terminology

**Grammar and style:**
- Correct grammar and spelling
- Appropriate verb tense (past for study results, present for established facts)
- Active voice when appropriate
- Concise without sacrificing clarity

### References

**Verify:**
- Adequate number of references
- Current literature included
- Key papers cited
- References formatted correctly
- All citations in reference list and vice versa
- No excessive self-citation

### Tables and Figures

**Assess:**
- Appropriate for data type
- Clear labels and legends
- High quality images
- Can stand alone
- No redundancy with text
- Statistical notation correct

## Ethical Considerations in Review

### Conflicts of Interest

**Disclose and recuse if:**
- Personal relationship with authors
- Financial interest in outcome
- Competing research
- Strong bias for or against topic
- Institutional conflict

### Fair and Constructive Review

**Provide:**
- Balanced assessment of strengths and weaknesses
- Specific, actionable suggestions
- Respectful tone
- Objective evaluation
- Recognition of limitations of study design

**Avoid:**
- Personal attacks
- Dismissive language
- Demanding unreasonable revisions
- Expecting perfect study
- Imposing personal preferences over standards

### Confidentiality

**Maintain:**
- Do not share manuscript
- Do not discuss with colleagues without permission
- Do not use ideas or data
- Destroy copies after review

## Recommendation Categories

**Accept:**
- Manuscript meets publication standards
- Minor editing only

**Minor revisions:**
- Small issues that can be addressed
- No additional data required
- Typically one round of revision

**Major revisions:**
- Significant concerns requiring substantial changes
- May require additional analyses
- May require additional data or experiments
- Typically re-reviewed

**Reject:**
- Fundamental flaws that cannot be corrected
- Insufficient novelty or significance
- Unethical conduct
- Fraudulent data

**Reject and resubmit:**
- Study has potential but needs substantial work
- Essentially new submission after major changes

## Writing the Review Report

### Structure

**Summary:**
- Brief overview (2-3 sentences)
- Overall assessment
- Key strengths (2-3 points)
- Key weaknesses (2-3 points)
- Recommendation

**Major comments:**
- Numbered
- Significant issues affecting validity, interpretation, or impact
- Specific and actionable
- Prioritized

**Minor comments:**
- Numbered
- Editorial, formatting, or clarification issues
- Line-specific comments
- Table/figure comments

### Tone and Language

**Use:**
- Professional, collegial tone
- "The authors state..." not "You state..."
- "This study shows..." not "Your study shows..."
- Constructive criticism
- Suggestions for improvement

**Avoid:**
- Harsh or dismissive language
- Personal pronouns
- Sarcasm
- Vague criticism
- Unreasonable demands

### Specific and Actionable Feedback

**Good:**
"The sample size calculation (page 8) does not account for expected dropout rate. Please revise to include expected dropout and explain how this affects enrollment targets."

**Poor:**
"Sample size is inadequate."

**Good:**
"Figure 2 would be clearer if error bars represented 95% CI rather than SEM. Please revise and update figure legend accordingly."

**Poor:**
"Figure 2 is confusing."

---

This reference provides comprehensive peer review standards for clinical manuscripts including case reports, clinical trials, diagnostic studies, observational studies, and systematic reviews. Use these criteria to conduct thorough, constructive peer reviews.

