# Scientific Hypothesis Generation: [Phenomenon Name]

## 1. Background & Context

### Phenomenon Description
[Clear description of the observation, pattern, or question that requires explanation. Include:
- What was observed or what question needs answering
- The specific context or system in which it occurs
- Any relevant constraints or boundary conditions
- Why this phenomenon is interesting or important]

### Current Understanding
[Synthesis of existing literature, including:
- What is already known about this phenomenon
- Established mechanisms or theories that may be relevant
- Key findings from recent research
- Gaps or limitations in current understanding
- Conflicting findings or unresolved debates

Include citations to key papers (Author et al., Year, Journal)]

### Knowledge Gaps
[Specific aspects that remain unexplained or poorly understood:
- What aspects of the phenomenon lack clear explanation?
- What contradictions exist in current understanding?
- What questions remain unanswered?]

---

## 2. Competing Hypotheses

### Hypothesis 1: [Concise Title]

**Mechanistic Explanation:**
[Detailed explanation of the proposed mechanism. This should explain HOW and WHY the phenomenon occurs, not just describe WHAT occurs. Include:
- Specific molecular, cellular, physiological, or population-level mechanisms
- Causal chain from initial trigger to observed outcome
- Key components, pathways, or factors involved
- Scale or level of explanation (molecular, cellular, organ, organism, population)]

**Supporting Evidence:**
[Evidence from literature that supports this hypothesis:
- Analogous mechanisms in related systems
- Direct evidence from relevant studies
- Theoretical frameworks that align with this hypothesis
- Include citations]

**Key Assumptions:**
[Explicit statement of assumptions underlying this hypothesis:
- What must be true for this hypothesis to hold?
- What conditions or contexts does it require?]

---

### Hypothesis 2: [Concise Title]

**Mechanistic Explanation:**
[Detailed mechanistic explanation distinct from Hypothesis 1]

**Supporting Evidence:**
[Evidence supporting this alternative explanation]

**Key Assumptions:**
[Assumptions underlying this hypothesis]

---

### Hypothesis 3: [Concise Title]

**Mechanistic Explanation:**
[Detailed mechanistic explanation distinct from previous hypotheses]

**Supporting Evidence:**
[Evidence supporting this explanation]

**Key Assumptions:**
[Assumptions underlying this hypothesis]

---

[Continue for Hypothesis 4, 5, etc. if applicable]

---

## 3. Quality Assessment

### Evaluation Against Core Criteria

| Criterion | Hypothesis 1 | Hypothesis 2 | Hypothesis 3 | [H4] | [H5] |
|-----------|--------------|--------------|--------------|------|------|
| **Testability** | [Rating & brief note] | [Rating & brief note] | [Rating & brief note] | | |
| **Falsifiability** | [Rating & brief note] | [Rating & brief note] | [Rating & brief note] | | |
| **Parsimony** | [Rating & brief note] | [Rating & brief note] | [Rating & brief note] | | |
| **Explanatory Power** | [Rating & brief note] | [Rating & brief note] | [Rating & brief note] | | |
| **Scope** | [Rating & brief note] | [Rating & brief note] | [Rating & brief note] | | |
| **Consistency** | [Rating & brief note] | [Rating & brief note] | [Rating & brief note] | | |

**Rating scale:** Strong / Moderate / Weak

### Detailed Evaluation

#### Hypothesis 1
**Strengths:**
- [Specific strength 1]
- [Specific strength 2]

**Weaknesses:**
- [Specific weakness 1]
- [Specific weakness 2]

**Overall Assessment:**
[Brief summary of hypothesis quality and viability]

#### Hypothesis 2
[Similar structure]

#### Hypothesis 3
[Similar structure]

---

## 4. Experimental Designs

### Testing Hypothesis 1: [Title]

**Experiment 1A: [Brief title]**

*Design Type:* [e.g., In vitro dose-response / In vivo knockout / Clinical RCT / Observational cohort / Computational model]

*Objective:* [What specific aspect of the hypothesis does this test?]

*Methods:*
- **System/Model:** [What system, organism, or population?]
- **Intervention/Manipulation:** [What is varied or manipulated?]
- **Measurements:** [What outcomes are measured?]
- **Controls:** [What control conditions?]
- **Sample Size:** [Estimated n, with justification if possible]
- **Analysis:** [Statistical or analytical approach]

*Expected Timeline:* [Rough estimate]

*Feasibility:* [High/Medium/Low, with brief justification]

**Experiment 1B: [Brief title - alternative or complementary approach]**
[Similar structure to 1A]

---

### Testing Hypothesis 2: [Title]

**Experiment 2A: [Brief title]**
[Structure as above]

**Experiment 2B: [Brief title]**
[Structure as above]

---

### Testing Hypothesis 3: [Title]

**Experiment 3A: [Brief title]**
[Structure as above]

---

## 5. Testable Predictions

### Predictions from Hypothesis 1

1. **Prediction 1.1:** [Specific, measurable prediction]
   - **Conditions:** [Under what conditions should this be observed?]
   - **Magnitude:** [Expected effect size or direction, if quantifiable]
   - **Falsification:** [What observation would falsify this prediction?]

2. **Prediction 1.2:** [Specific, measurable prediction]
   - **Conditions:** [Conditions]
   - **Magnitude:** [Expected effect]
   - **Falsification:** [Falsifying observation]

3. **Prediction 1.3:** [Additional prediction]

---

### Predictions from Hypothesis 2

1. **Prediction 2.1:** [Specific, measurable prediction]
   - **Conditions:** [Conditions]
   - **Magnitude:** [Expected effect]
   - **Falsification:** [Falsifying observation]

2. **Prediction 2.2:** [Additional prediction]

---

### Predictions from Hypothesis 3

1. **Prediction 3.1:** [Specific, measurable prediction]
   - **Conditions:** [Conditions]
   - **Magnitude:** [Expected effect]
   - **Falsification:** [Falsifying observation]

---

## 6. Critical Comparisons

### Distinguishing Between Hypotheses

**Comparison: Hypothesis 1 vs. Hypothesis 2**

*Key Distinguishing Feature:*
[What is the fundamental difference in mechanism or prediction?]

*Discriminating Experiment:*
[What experiment or observation would clearly favor one over the other?]

*Outcome Interpretation:*
- If [Result A], then Hypothesis 1 is supported
- If [Result B], then Hypothesis 2 is supported
- If [Result C], then both/neither are supported

---

**Comparison: Hypothesis 1 vs. Hypothesis 3**
[Similar structure]

---

**Comparison: Hypothesis 2 vs. Hypothesis 3**
[Similar structure]

---

### Priority Experiments

**Highest Priority Test:**
[Which experiment would most efficiently distinguish between hypotheses or most definitively test a hypothesis?]

**Justification:**
[Why is this the highest priority? Consider informativeness, feasibility, and cost]

**Secondary Priority Tests:**
1. [Second most important experiment]
2. [Third most important]

---

## 7. Summary & Recommendations

### Summary of Hypotheses

[Brief paragraph summarizing the competing hypotheses and their relationships]

### Recommended Testing Sequence

**Phase 1 (Initial Tests):**
[Which experiments should be done first? Why?]

**Phase 2 (Contingent on Phase 1 results):**
[What follow-up experiments depend on initial results?]

**Phase 3 (Validation and Extension):**
[How to validate findings and extend to broader contexts?]

### Expected Outcomes and Implications

**If Hypothesis 1 is supported:**
[What would this mean for the field? What new questions arise?]

**If Hypothesis 2 is supported:**
[Implications and new questions]

**If Hypothesis 3 is supported:**
[Implications and new questions]

**If multiple hypotheses are partially supported:**
[How might mechanisms combine or interact?]

### Open Questions

[What questions remain even after these hypotheses are tested?]

---

## References

[List key papers cited in the document, formatted consistently]

1. Author1, A.B., & Author2, C.D. (Year). Title of paper. *Journal Name*, Volume(Issue), pages. DOI or URL

2. [Continue for all citations]

---

## Notes on Using This Template

- Replace all bracketed instructions with actual content
- Not all sections are mandatory - adapt to your specific hypothesis generation task
- For simpler phenomena, 3 hypotheses may be sufficient; complex phenomena may warrant 4-5
- Experimental designs should be detailed enough to be actionable but can be refined later
- Predictions should be as specific and quantitative as possible
- The template emphasizes both generating hypotheses and planning how to test them
- Citation format can be adjusted to field-specific standards
