# NSF Project Summary Template

**IMPORTANT**: NSF requires three labeled sections in the project summary (max 1 page):
1. Overview
2. Intellectual Merit  
3. Broader Impacts

---

## Overview

[Write a paragraph suitable for public dissemination that explains:
- The research question or problem
- The approach or methods
- Expected outcomes
- Significance

This should be accessible to a broad audience including non-scientists. Avoid jargon.]

**Example:**
This project investigates how coastal wetlands respond to rising sea levels and increased storm intensity caused by climate change. Using a combination of field observations, remote sensing, and computer modeling across 20 sites along the Atlantic coast, we will determine whether wetlands can migrate inland fast enough to keep pace with sea level rise. Results will inform coastal management policies and help predict the fate of critical ecosystems that protect shorelines and support fisheries. This work will train 5 graduate students and 10 undergraduates, with priority recruitment from underrepresented groups through partnerships with minority-serving institutions.

---

## Intellectual Merit

[Address the question: What is the potential for the proposed activity to advance knowledge?

Include:
- Why the research is important scientifically
- What knowledge gap it addresses
- What will be learned
- Novel aspects of the approach
- How it advances the field]

**Example:**
This research addresses a critical gap in understanding coastal wetland resilience under accelerating climate change. Current models of wetland migration fail to account for biological constraints on vegetation establishment and feedbacks between sediment dynamics and plant growth. We will develop the first integrated model coupling hydrological, ecological, and geomorphological processes across multiple spatial scales. Our novel approach combines high-resolution LiDAR elevation data with experimental manipulations of sediment and salinity to parameterize vegetation response functions. Expected outcomes include quantitative predictions of wetland migration rates under different sea level rise scenarios, identification of landscape features that facilitate or impede migration, and new theory on ecosystem tipping points. This work will transform our ability to predict and manage coastal ecosystem responses to climate change.

---

## Broader Impacts

[Address the question: What is the potential for the proposed activity to benefit society?

Must address at least one of NSF's five broader impacts areas with specific, measurable activities:
1. Advance discovery while promoting teaching, training, and learning
2. Broaden participation of underrepresented groups
3. Enhance infrastructure for research and education  
4. Broadly disseminate to enhance scientific understanding
5. Benefit society

Be SPECIFIC with concrete activities, timelines, and assessment plans.]

**Example:**
This project will generate significant broader impacts through three integrated activities:

**1. Education and Training**: We will train 5 PhD students and 10 undergraduates in interdisciplinary coastal science, emphasizing field methods, remote sensing, and quantitative modeling. Undergraduates will participate through summer research internships (10 weeks, $5,000 stipends) with mentorship from graduate students. We will recruit 50% of undergraduates from groups underrepresented in STEM through partnerships with 4 historically Black colleges and universities (HBCUs). Students will present results at the Annual Biogeographical Research Conference and co-author peer-reviewed publications.

**2. Stakeholder Engagement and Policy Impact**: We will partner with 5 state coastal management agencies and The Nature Conservancy to translate research findings into management tools. Annual workshops will bring together 30 coastal managers, conservation practitioners, and researchers to co-develop decision-support frameworks. Results will inform state sea level rise adaptation plans, wetland restoration prioritization, and land acquisition strategies affecting 500,000 acres of coastal habitat.

**3. Public Science Communication**: We will create a publicly accessible web-based visualization tool showing projected wetland changes under different climate scenarios for the entire Atlantic coast. The tool will be promoted through social media, state agency websites, and science museums, with expected reach of 50,000 users. We will also develop bilingual (English/Spanish) educational materials for K-12 teachers, piloted in 10 schools serving predominantly underrepresented students.

Impact will be assessed through pre/post surveys of student participants, tracking of research participants into STEM careers, documentation of policy adoptions by management agencies, and analytics on public engagement platform usage.

---

## Formatting Requirements

- **Page Limit**: 1 page maximum
- **Margins**: 1 inch all sides
- **Font**: 11-point or larger (Times Roman, Arial, Palatino, Computer Modern)
- **Section Headers**: Must use exactly these three labels:
  - Overview
  - Intellectual Merit
  - Broader Impacts
- **Public Accessibility**: Overview section suitable for general public

## Common Mistakes to Avoid

❌ **Don't** omit any of the three required section headings
❌ **Don't** make broader impacts vague ("will train students")
❌ **Don't** use jargon in the Overview
❌ **Don't** exceed 1 page
❌ **Don't** forget to mention preliminary data or team qualifications
❌ **Don't** make broader impacts an afterthought (they're equally important)

✅ **Do** make all three sections substantive
✅ **Do** be specific about broader impacts activities
✅ **Do** write Overview for broad audience
✅ **Do** convey enthusiasm and significance
✅ **Do** proofread carefully (this is the first thing reviewers see)

