---
name: artifacts-builder
description: Create interactive, self-contained artifacts like mini-apps, visualizations, calculators, and tools that can be embedded or used standalone. Use when building interactive calculators, creating data visualizations, making mini web apps, building embeddable widgets, creating interactive demos, making tools for specific tasks, or generating standalone HTML/JS applications.
---

# Artifacts Builder - Claude.ai HTML Artifacts

## When to use this skill

- Building interactive calculators and converters
- Creating data visualizations and charts
- Making mini web applications
- Building embeddable widgets for websites
- Creating interactive demos and prototypes
- Making tools for specific tasks (generators, validators)
- Generating standalone HTML/JavaScript apps
- Building interactive forms and quizzes
- Creating educational interactive content
- Making API testing or debugging tools
- Building configuration generators
- Creating shareable interactive examples

## When to use this skill

- Creating interactive HTML artifacts in Claude.ai.
- When working on related tasks or features
- During development that requires this expertise

**Use when**: Creating interactive HTML artifacts in Claude.ai.

## Pattern
\`\`\`html
<!DOCTYPE html>
<html>
<body>
  <script src="https://cdn.tailwindcss.com"></script>
  <div class="p-8">Content here</div>
</body>
</html>
\`\`\`
