---
name: document-processing-pdf
description: Process, parse, create, and manipulate PDF documents using libraries like pdf-lib, PDFKit, or pdf-parse for document generation, data extraction, and PDF manipulation. Use when generating PDFs from HTML, extracting text from PDFs, merging or splitting PDFs, adding watermarks, filling PDF forms, creating invoices and reports, parsing legal documents, or building document management systems.
---

# Document Processing - PDF Files

## When to use this skill

- Generating PDFs from HTML templates
- Extracting text and data from PDF documents
- Merging multiple PDFs into one document
- Splitting large PDFs into smaller files
- Adding watermarks or stamps to PDFs
- Filling PDF forms programmatically
- Creating invoices, receipts, and reports as PDFs
- Parsing legal documents and contracts
- Converting PDFs to images or text
- Building document management systems
- Extracting tables and structured data from PDFs
- Creating searchable PDFs (OCR integration)

## When to use this skill

- Generating, extracting data from PDFs.
- When working on related tasks or features
- During development that requires this expertise

**Use when**: Generating, extracting data from PDFs.

## Example
\`\`\`typescript
import PDFDocument from 'pdfkit';

const doc = new PDFDocument();
doc.text('Hello World');
doc.end();
\`\`\`

## Resources
- [PDFKit](https://pdfkit.org/)
