---
name: skill-creator
description: Create well-structured, comprehensive Claude skills with clear activation criteria, detailed descriptions, usage examples, and proper documentation following best practices. Use when documenting new workflows, creating reusable skill patterns, establishing coding standards as skills, building team knowledge base, or expanding the skills library with new capabilities.
---

# Skill Creator - Meta-Skill for Creating Skills

## When to use this skill

- Documenting new workflows as skills
- Creating reusable skill patterns
- Establishing coding standards as skills
- Building team knowledge bases
- Expanding skills library with new capabilities
- Documenting best practices systematically
- Creating activation-oriented descriptions
- Writing comprehensive usage examples
- Structuring skills following best practices
- Creating skills from tribal knowledge
- Documenting domain-specific expertise
- Building organizational skill libraries

## When to use this skill

- Creating new Claude skills, documenting workflows.
- When working on related tasks or features
- During development that requires this expertise

**Use when**: Creating new Claude skills, documenting workflows.

## Structure
1. **Title** - Clear, descriptive
2. **Use when** - Activation criteria
3. **Core Principles** - 3-5 key concepts
4. **Examples** - Practical code/patterns
5. **Resources** - External links

## Template
\`\`\`markdown
# Skill Name - Brief Description

**Use when**: Clear trigger conditions

## Core Concepts
- Concept 1
- Concept 2

## Example
\\`\\`\\`typescript
// Code example
\\`\\`\\`

## Resources
- [Link](https://example.com)
\`\`\`

## Resources
- [Claude Skills Documentation](https://docs.anthropic.com/claude/docs/skills)
