---
name: tailwind-design-system
description: Create consistent, scalable design systems using Tailwind CSS utility classes with custom themes, design tokens, and responsive design patterns. Use when building design systems, implementing custom themes, creating reusable utility patterns, configuring Tailwind theme extensions, implementing dark mode, building responsive layouts, creating design tokens, using arbitrary values, or establishing consistent spacing and typography scales.
---

# Tailwind CSS - Utility-First Styling

## When to use this skill

- Building design systems with Tailwind CSS
- Implementing custom themes and design tokens
- Creating reusable utility class patterns
- Configuring Tailwind theme extensions
- Implementing light and dark mode themes
- Building responsive layouts with Tailwind grid/flexbox
- Creating consistent spacing and typography scales
- Using arbitrary values for one-off styles
- Implementing custom color palettes
- Building component variants with Tailwind
- Creating animation and transition systems
- Establishing design consistency across projects

## When to use this skill

- Styling with Tailwind, creating design systems, responsive layouts.
- When working on related tasks or features
- During development that requires this expertise

**Use when**: Styling with Tailwind, creating design systems, responsive layouts.

## Core Pattern
\`\`\`jsx
<div className="flex items-center justify-between p-4 bg-white dark:bg-gray-800 rounded-lg shadow-md">
  <h2 className="text-xl font-bold">Title</h2>
</div>
\`\`\`

## Resources
- [Tailwind CSS](https://tailwindcss.com/)
