---
name: threat-hunting
description: Proactively search for security threats, vulnerabilities, and suspicious patterns in applications and infrastructure before they cause damage. Use when conducting security audits, identifying vulnerabilities, analyzing security logs, detecting suspicious patterns, investigating potential breaches, performing penetration testing, or implementing security monitoring.
---

# Threat Hunting - Security Analysis

## When to use this skill

- Conducting proactive security audits
- Identifying vulnerabilities before exploitation
- Analyzing security logs for threats
- Detecting suspicious access patterns
- Investigating potential security breaches
- Performing penetration testing
- Implementing security monitoring
- Reviewing authentication logs
- Detecting anomalous behavior
- Identifying security misconfigurations
- Analyzing attack surfaces
- Building threat detection systems

## When to use this skill

- Proactive security monitoring, threat detection.
- When working on related tasks or features
- During development that requires this expertise

**Use when**: Proactive security monitoring, threat detection.

## Patterns
- Unusual network traffic
- Failed auth attempts
- Privilege escalation
- Data exfiltration

## Resources
- [MITRE ATT&CK](https://attack.mitre.org/)
