---
name: vercel-deployment
description: Deploy and optimize applications on Vercel with preview deployments, edge functions, environment variables, and performance monitoring. Use when deploying Next.js applications, setting up preview deployments per pull request, configuring environment variables, using Vercel Edge Functions, optimizing build performance, implementing redirects and rewrites, configuring custom domains, or monitoring application performance with Vercel Analytics.
---

# Vercel Deployment - Production Deployments

## When to use this skill

- Deploying Next.js applications to Vercel
- Setting up automatic preview deployments
- Configuring environment variables per environment
- Using Vercel Edge Functions at the edge
- Optimizing build times and caching
- Implementing redirects, rewrites, and headers
- Configuring custom domains and SSL
- Monitoring performance with Vercel Analytics
- Implementing incremental static regeneration
- Setting up monorepo deployments with Turborepo
- Configuring serverless function regions
- Using Vercel KV, Postgres, or Blob storage

## When to use this skill

- Deploying Next.js apps, configuring edge functions, analytics.
- When working on related tasks or features
- During development that requires this expertise

**Use when**: Deploying Next.js apps, configuring edge functions, analytics.

## Deploy
\`\`\`bash
vercel --prod
\`\`\`

## Resources
- [Vercel Docs](https://vercel.com/docs)
