# Product Planning Workflow

## Overview

Step-by-step process for creating a product roadmap from vision to actionable features.

---

## Phase 1: Vision Clarification

### Gather Inputs
1. Review any existing product documentation
2. Understand user/stakeholder requirements
3. Identify target users and use cases
4. Note technical constraints and dependencies

### Define Success Criteria
```
Ask these questions:
- What problem are we solving?
- Who benefits and how?
- How will we measure success?
- What are the non-negotiables?
```

---

## Phase 2: Feature Discovery

### Brainstorm Features
1. List all potential features (no filtering yet)
2. Group related features into themes
3. Map features to user problems
4. Identify MVP vs. future features

### Prioritization Matrix
```
For each feature, score 1-5:
- Impact: How much value does it deliver?
- Effort: How complex to implement?
- Risk: How uncertain is it?
- Dependencies: What must come first?
```

---

## Phase 3: Roadmap Construction

### Define Phases
```
Phase 1 (MVP):
- Core features only
- Minimal viable scope
- Must-have functionality

Phase 2 (Enhancement):
- Quality of life improvements
- Extended functionality
- Performance optimization

Phase 3 (Growth):
- Advanced features
- Scaling capabilities
- Nice-to-have items
```

### Create Timeline
1. Estimate effort for each feature (T-shirt sizing)
2. Order by dependencies and priority
3. Group into logical milestones
4. Set realistic target dates

---

## Phase 4: Validation

### Checklist
- [ ] All user problems addressed
- [ ] Dependencies ordered correctly
- [ ] MVP is truly minimal
- [ ] Estimates are realistic
- [ ] Success metrics defined

### Review Questions
```
- Can we ship Phase 1 independently?
- Are features clearly scoped?
- Is the timeline achievable?
- What risks need mitigation?
```

---

## Outputs

1. **roadmap.md** - Phased feature list with priorities
2. **Updated todos** - Next steps for spec shaping
3. **Decision log** - Key tradeoffs documented

---

## Next Steps

After planning approval:
1. Select first feature for specification
2. Load `shape-spec` skill
3. Begin research and discovery
