# About Swift

Understand the high-level goals of the language.

Swift is a fantastic way to write software
for phones, tablets, desktops, servers,
or anything else that runs code.
It's a safe and fast programming language
that combines the best in modern language thinking
with wisdom from a diverse open source community.

Swift is friendly to new programmers,
without sacrificing the power and flexibility
that experienced programmers need.
It's an industrial-quality programming language
that's as expressive and enjoyable as a scripting language.
The compiler is optimized for performance
and the language is optimized for development,
without compromising on either.

Swift defines away large classes of common programming errors
by adopting modern programming patterns:

- Variables are always initialized before use.
- Array indices are checked for out-of-bounds errors.
- Integers are checked for overflow.
- Optionals ensure that `nil` values are handled explicitly.
- Memory is managed automatically.
- Error handling allows controlled recovery from unexpected failures.

Swift code is compiled and optimized to get the most out of modern hardware.
The syntax and standard library have been designed
based on the guiding principle that
the obvious way to write your code should also perform the best.
Its combination of safety and speed make Swift an excellent choice for
everything from "Hello, world!" to an entire operating system.

Swift combines a modern, lightweight syntax
that's familiar for developers coming from other popular languages
with powerful features like type inference and pattern matching,
allowing complex ideas to be expressed in a clear and concise manner.
As a result, code is easier to read, write, and maintain.

Swift continues to evolve with thoughtful new features and powerful capabilities.
The goals for Swift are ambitious.
We can’t wait to see what you create with it.

<!--
This source file is part of the Swift.org open source project

Copyright (c) 2014 - 2022 Apple Inc. and the Swift project authors
Licensed under Apache License v2.0 with Runtime Library Exception

See https://swift.org/LICENSE.txt for license information
See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
-->
