---
name: landing-page-builder
description: 비전공자도 쉽게 전환율 높은 랜딩페이지를 만들 수 있도록 돕는 스킬. 카피라이팅, 디자인, 기술 구현을 한 번에 처리합니다.
version: 1.0.0
author: BSD Vibe Coding Center
tags: [landing-page, conversion, marketing, framer, webflow]
---

# 🚀 랜딩페이지 빌더 스킬

이 스킬은 BSD 바이브코딩 수강생들이 **전환율 높은 랜딩페이지**를 빠르고 쉽게 제작할 수 있도록 돕습니다.

## 📋 이 스킬이 하는 일

1. **목적 분석**: 사용자의 비즈니스 목표와 타겟 고객 파악
2. **구조 설계**: 전환율을 극대화하는 섹션 구성
3. **카피라이팅**: 설득력 있는 헤드라인과 CTA 작성
4. **디자인 가이드**: 색상, 폰트, 레이아웃 추천
5. **코드 생성**: HTML/CSS 또는 Framer/Webflow 코드 제공

## 🎯 언제 이 스킬을 사용하나요?

- "제품 판매를 위한 랜딩페이지를 만들고 싶어요"
- "무료 eBook 다운로드 페이지가 필요해요"
- "웨비나 신청 페이지를 만들어주세요"
- "이메일 구독 유도 페이지를 만들고 싶어요"

## 💡 사용 방법

### 기본 사용법
```
"온라인 강의 판매를 위한 랜딩페이지를 만들어줘. 
타겟은 30-40대 직장인이고, 강의 제목은 '바이브코딩 마스터클래스'야."
```

### 상세 요청
```
"SaaS 제품 랜딩페이지를 만들어줘. 
- 제품명: TaskFlow
- 타겟: 스타트업 창업자
- 핵심 가치: 업무 자동화로 시간 절약
- 원하는 색상: 블루 계열
- CTA: 14일 무료 체험"
```

## 📐 랜딩페이지 구조 템플릿

### 1. Hero Section (히어로 섹션)
- **헤드라인**: 명확한 가치 제안 (10단어 이내)
- **서브헤드라인**: 구체적인 혜택 설명 (20단어 이내)
- **CTA 버튼**: 행동 유도 문구
- **히어로 이미지/영상**: 제품/서비스 시각화

### 2. Problem Section (문제 제시)
- 타겟 고객이 겪는 3가지 주요 고통점
- 공감을 이끌어내는 스토리텔링

### 3. Solution Section (솔루션 제시)
- 제품/서비스가 해결하는 방법
- 핵심 기능 3-5가지 (아이콘 + 설명)

### 4. How It Works (작동 방식)
- 3단계 프로세스 설명
- 간단하고 직관적인 플로우

### 5. Benefits Section (혜택)
- 기능이 아닌 결과 중심 설명
- 수치와 데이터로 신뢰 구축

### 6. Social Proof (사회적 증거)
- 고객 후기 3-5개
- 로고월 (클라이언트/파트너 로고)
- 통계 (사용자 수, 만족도 등)

### 7. Pricing (가격)
- 명확한 가격 표시
- 티어별 비교표 (선택사항)
- 보증/환불 정책

### 8. FAQ (자주 묻는 질문)
- 구매 결정을 방해하는 의문 해소
- 5-7개 질문과 답변

### 9. Final CTA (최종 행동 유도)
- Hero Section CTA 반복
- 긴급성 요소 추가 (할인 기한 등)

### 10. Footer (푸터)
- 연락처 정보
- 소셜 미디어 링크
- 개인정보처리방침, 이용약관

## 🎨 디자인 원칙

### 색상 선택
```
- Primary Color: 브랜드 핵심 색상 (CTA 버튼에 사용)
- Secondary Color: 보조 색상 (섹션 배경)
- Accent Color: 강조 색상 (아이콘, 하이라이트)
- Neutral Colors: 텍스트와 배경 (Gray scale)
```

### 타이포그래피
```
- Headline Font: 굵고 임팩트 있는 폰트 (예: Montserrat Bold)
- Body Font: 가독성 좋은 폰트 (예: Inter, Pretendard)
- 크기 비율: 헤드라인 48-64px, 서브헤드 24-32px, 본문 16-18px
```

### 레이아웃
```
- 모바일 우선 반응형 디자인
- Z-패턴 또는 F-패턴 레이아웃
- 충분한 여백 (breathing space)
- 명확한 시각적 계층 구조
```

## ✍️ 카피라이팅 가이드

### 헤드라인 공식
1. **결과 중심**: "30일 만에 월 100만원 수익 달성"
2. **문제 해결**: "더 이상 코딩 몰라서 사업 포기하지 마세요"
3. **호기심 자극**: "1만 명이 선택한 비밀 전략"

### CTA 작성 팁
❌ 나쁜 예: "제출", "클릭", "여기"
✅ 좋은 예: 
- "무료로 시작하기"
- "내 첫 랜딩페이지 만들기"
- "14일 무료 체험 신청"
- "지금 바로 수익 올리기"

### 설득력 있는 문구
- **긴급성**: "48시간 한정 할인"
- **희소성**: "선착순 100명만 가능"
- **사회적 증거**: "5,000명이 이미 사용 중"
- **권위**: "업계 1위 전문가 추천"
- **보증**: "30일 무조건 환불 보장"

## 🛠️ 기술 구현 옵션

### Option 1: HTML/CSS/JavaScript (순수 웹)
```html
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>랜딩페이지 제목</title>
    <style>
        /* 반응형 CSS 포함 */
    </style>
</head>
<body>
    <!-- 구조적 HTML -->
</body>
</html>
```

### Option 2: Framer (노코드)
- Framer Components 활용
- 인터랙션 애니메이션 추가
- SEO 최적화 자동 처리

### Option 3: Webflow (노코드)
- CMS 연동 가능
- 고급 애니메이션
- E-commerce 통합

### Option 4: Next.js + TailwindCSS (프로페셔널)
```javascript
// 컴포넌트 기반 구조
// SEO 최적화
// 빠른 로딩 속도
```

## 📊 전환율 최적화 체크리스트

### 로딩 속도
- [ ] 이미지 최적화 (WebP 포맷)
- [ ] 3초 이내 로딩
- [ ] 모바일 최적화

### UX/UI
- [ ] 명확한 CTA 버튼 (3개 이내)
- [ ] 스크롤 없이 첫 화면에서 가치 파악 가능
- [ ] 폼 필드 최소화 (3-5개 이내)

### 카피
- [ ] 헤드라인에 핵심 가치 명시
- [ ] 고객 언어 사용 (전문 용어 X)
- [ ] 수치와 구체적 혜택 포함

### 신뢰 요소
- [ ] 고객 후기 3개 이상
- [ ] 보안 인증 마크
- [ ] 환불 보장 명시
- [ ] 연락처 정보 표시

## 🎓 BSD 학생 특화 기능

### 1. 빠른 프로토타입
"30분 안에 기본 구조 잡아줘"라고 요청하면 핵심 섹션만 담긴 MVP 버전 제공

### 2. 산업별 템플릿
- 코칭/컨설팅
- 온라인 강의
- SaaS 제품
- E-commerce
- 지역 비즈니스

### 3. A/B 테스트 버전
두 가지 헤드라인 또는 CTA 버전을 자동으로 생성하여 테스트 가능

### 4. 코드 설명 모드
"초보자를 위한 설명 추가해줘"라고 하면 각 코드 블록에 한글 주석 포함

## 💬 예제 대화

**사용자**: "헬스 코칭 서비스 랜딩페이지 만들어줘"

**Claude**: 
"헬스 코칭 랜딩페이지를 만들어드리겠습니다. 몇 가지 질문 드릴게요:

1. 타겟 고객은 누구인가요? (예: 30대 직장인, 산후조리 여성 등)
2. 핵심 서비스는? (1:1 PT, 그룹 코칭, 온라인 프로그램 등)
3. 가격대는? (공개/비공개)
4. 원하는 전체 분위기는? (활기찬/프로페셔널/친근한 등)"

**사용자**: "30대 직장인, 온라인 그룹 코칭, 월 29만원, 프로페셔널한 느낌"

**Claude**: [상세한 랜딩페이지 구조와 코드 제공]

## 🔄 반복 개선 프로세스

1. **초안 생성**: 기본 구조와 카피
2. **피드백 수렴**: "헤드라인을 더 강렬하게" 등의 요청
3. **수정 반영**: 즉시 업데이트된 버전 제공
4. **최종 확인**: A/B 테스트 버전 제안

## ⚠️ 주의사항

### 하지 말아야 할 것
- ❌ 너무 많은 정보로 혼란 유발
- ❌ 5개 이상의 CTA 버튼
- ❌ 자동재생 동영상/음악
- ❌ 과도한 애니메이션
- ❌ 작은 폰트 크기 (14px 이하)

### 법적 주의사항
- 저작권 있는 이미지 사용 금지
- 허위 과장 광고 금지
- 개인정보 처리 방침 필수 포함
- 환불 정책 명확히 명시

## 📚 추가 리소스

### 무료 이미지/아이콘
- Unsplash: 고품질 무료 이미지
- Pexels: 상업적 이용 가능 사진
- Lucide Icons: 깔끔한 아이콘 세트
- Heroicons: Tailwind용 아이콘

### 색상 팔레트 도구
- Coolors.co: 자동 색상 조합
- Adobe Color: 색상 이론 기반 생성

### 폰트 추천
- 한글: Pretendard, Noto Sans KR, Spoqa Han Sans
- 영문: Inter, Montserrat, Poppins

## 🚀 빠른 시작 명령어

### 기본 생성
```
"[산업명] 랜딩페이지 만들어줘. 타겟은 [고객], 제품은 [설명]"
```

### 특정 플랫폼용
```
"Framer로 [제품명] 랜딩페이지 만들어줘"
```

### 수정 요청
```
"헤드라인을 더 임팩트 있게 바꿔줘"
"CTA 색상을 빨간색으로 변경해줘"
"모바일 뷰 최적화해줘"
```

---

## 🎯 핵심 정리

이 스킬을 사용하면:
✅ 30분 안에 프로페셔널한 랜딩페이지 완성
✅ 전환율 최적화된 구조 자동 적용
✅ 설득력 있는 카피라이팅 제공
✅ 반응형 디자인 기본 탑재
✅ 즉시 수정 가능한 코드 제공

**BSD 학생이라면**: 이 스킬 하나로 클라이언트에게 랜딩페이지 제작 서비스를 제공하거나, 자신의 온라인 비즈니스를 시작할 수 있습니다! 🎉
