# Concept Development Stages

Progressive stages from vague intuition to testable framework. Not all concepts move through all stages—some crystallize quickly, others need extensive interrogation.

## Stage 0: Intuition (Pre-Conceptual)

**Characteristics:**
- "There's something about X..."
- Can't articulate clearly
- Multiple overlapping ideas
- Concrete examples but no pattern

**User signals:**
- "I've been thinking about..."
- "Something feels off about..."
- "There's this thing that keeps happening..."
- "I can't quite put my finger on it but..."

**What's needed:**
- Permission to be vague
- Examples before theory
- Questions not answers
- Patient excavation

**Interrogation approach:**
- @explorer: "Tell me a specific instance"
- @strategist: "What decision does this affect?"
- @builder: "If this were true, what would you do differently?"

**Output from this stage:** Collection of concrete examples, initial pattern recognition

---

## Stage 1: Articulation (Naming)

**Characteristics:**
- Can state core idea in 2-3 sentences
- Still fuzzy at edges
- May be purely intuitive
- No structure yet

**User signals:**
- "I think X is actually Y"
- "What if we thought of it as..."
- "The problem is..."
- "Here's what I'm seeing..."

**What's needed:**
- Crisp statement of intuition
- Distinction from related concepts
- First pass at "what varies"
- Provisional name/handle

**Interrogation approach:**
- @strategist: "What's the underlying game?"
- @pragmatist: "How is this different from [existing thing]?"
- @dissident_poet: "Say it more precisely"

**Key questions:**
- What's the simplest statement of this idea?
- What's an example that clearly fits?
- What's an example that clearly doesn't fit?
- What existing concept is this closest to?
- How is it different?

**Output from this stage:** Named concept with 1-2 sentence core statement

---

## Stage 2: Dimensionalization (Structure)

**Characteristics:**
- Concept has internal structure
- Key factors identified
- Variation explained
- Still exploratory

**User signals:**
- "There are really two things going on..."
- "It depends on..."
- "The key factors seem to be..."
- "I see a pattern across cases..."

**What's needed:**
- Identify dimensions/factors
- Define endpoints or ranges
- Explain what varies and why
- Create provisional taxonomy

**Interrogation approach:**
- @cartographer: "What's upstream/downstream?"
- @strategist: "What domain is this?"
- @theorist: "What's the phase transition?"

**Key questions:**
- What are the 2-3 key dimensions?
- How do you define high vs low on each dimension?
- What cases occupy different positions?
- Do dimensions interact (compound effects)?
- Are dimensions truly independent?

**Common structures discovered:**
- **Continuum:** Simple ↔ Complex
- **Binary:** Present/Absent, Yes/No
- **Categorical:** Type A, B, C
- **Multi-dimensional:** Grid (2D), Cube (3D)
- **Sequential:** Stages 1 → 2 → 3

**Output from this stage:** Dimensional structure with defined factors

---

## Stage 3: Mapping (Examples)

**Characteristics:**
- Multiple cases mapped to framework
- Pattern clear across examples
- Explanatory power demonstrated
- Edge cases identified

**User signals:**
- "So Air India is here, Air Canada is here..."
- "This explains both the success and failure..."
- "The pattern holds across cases..."
- "But what about [edge case]?"

**What's needed:**
- 5-10 concrete examples
- Mix of successes and failures
- Clear mapping to framework
- Boundary cases (where framework breaks)

**Interrogation approach:**
- @pragmatist: "Show me the evidence"
- @cartographer: "Where do existing cases fall?"
- @rebel_econ: "Where's the fragility?"

**Key questions:**
- What are 3 clear positive examples?
- What are 3 clear negative examples?
- What case is surprising when mapped?
- Where does the framework not apply?
- What edge cases challenge the structure?

**Output from this stage:** Framework with mapped examples and known boundaries

---

## Stage 4: Operationalization (Testing)

**Characteristics:**
- Concept is falsifiable
- Tests designed
- Predictions generated
- Application criteria clear

**User signals:**
- "We could test this by..."
- "If this is true, we'd see..."
- "To apply this, you'd..."
- "This would fail if..."

**What's needed:**
- Falsification criteria
- Minimal tests
- Prediction generation
- Application heuristics

**Interrogation approach:**
- @pragmatist: "What would prove this wrong?"
- @builder: "What's the smallest test?"
- @strategist: "What decision does this enable?"

**Key questions:**
- What would prove this concept wrong?
- What's the simplest test?
- What predictions does this generate?
- How would someone apply this?
- What would count as misapplication?
- When should you NOT use this framework?

**Test types:**
- **Explanatory:** Does it explain past cases?
- **Predictive:** Does it predict new cases?
- **Diagnostic:** Can others apply it consistently?
- **Prescriptive:** Does it change decisions/actions?

**Output from this stage:** Testable framework with falsification criteria

---

## Stage 5: Refinement (Tensions)

**Characteristics:**
- Tensions acknowledged
- Tradeoffs explicit
- Limitations clear
- Alternative views integrated

**User signals:**
- "But there's a tension between..."
- "This works except when..."
- "The tradeoff is..."
- "An alternative view would be..."

**What's needed:**
- Honest complexity
- Acknowledged limitations
- Integration of critiques
- Explicit tradeoffs

**Interrogation approach:**
- @ethicist: "What dignity is at stake?"
- @jester: "What if exactly backwards?"
- @monk: "What's the paradox?"

**Key questions:**
- What's the strongest critique?
- What tensions remain unresolved?
- What tradeoffs are inherent?
- When does this framework mislead?
- What alternative framings exist?
- Can alternatives be integrated?

**Common tensions:**
- Simplicity vs completeness
- Prescriptive vs descriptive
- Universal vs contextual
- Mechanistic vs emergent
- Reductionist vs holistic

**Output from this stage:** Mature framework with acknowledged tensions

---

## Stage 6: Doctrine (Action)

**Characteristics:**
- Clear action implications
- Decision heuristics
- Movement strategies
- Implementation guidance

**User signals:**
- "So the doctrine is..."
- "This means you should..."
- "To move from A to B, you'd..."
- "The prioritization is..."

**What's needed:**
- Actionable implications
- Priority guidance
- Movement/transition strategies
- Practical heuristics

**Interrogation approach:**
- @strategist: "What's the doctrine?"
- @builder: "How do you actually do this?"
- @cartographer: "What's the movement path?"

**Key questions:**
- What should someone do differently?
- How do you prioritize using this framework?
- What's the optimal sequence?
- How do you move between zones/states?
- What infrastructure enables movement?
- What's the anti-pattern to avoid?

**Doctrine types:**
- **Selection:** Where to focus effort
- **Sequencing:** What order to do things
- **Movement:** How to transition between states
- **Avoidance:** What NOT to do
- **Detection:** How to recognize patterns
- **Response:** What action per pattern

**Output from this stage:** Framework with actionable doctrine

---

## Stage 7: Communication (Artifact)

**Characteristics:**
- Ready for external sharing
- Visual representation
- Self-contained explanation
- Teachable to others

**User signals:**
- "Turn this into a deck"
- "Make this shareable"
- "How do I explain this?"
- "Create a one-pager"

**What's needed:**
- Visual framework diagram
- Clear explanation
- Concrete examples
- Application guide

**Integration point:** Hand to `strategy-to-artifact` skill for deck/one-pager creation

**Output from this stage:** Shareable artifact (deck, one-pager, diagram)

---

## Non-Linear Progression

Concepts don't always progress sequentially:

### Skip Patterns

**Rapid Crystallization:**
- Stage 0 → Stage 2 → Stage 4
- When pattern is immediately obvious
- Example: "This is just a 2x2 grid of X and Y"

**Intuition to Doctrine:**
- Stage 0 → Stage 1 → Stage 6
- When action is clear before structure
- Example: "I don't know why but the doctrine is X"

**Structure to Examples:**
- Stage 2 → Stage 3
- Framework first, cases second
- Example: Deductive frameworks

### Recursive Patterns

**Refinement Loop:**
- Stage 3 ↔ Stage 5
- Map examples, find tensions, adjust framework, remap
- Continue until stable

**Testing Loop:**
- Stage 4 ↔ Stage 5
- Design test, find failure mode, refine, retest
- Continue until robust

### Abandonment Patterns

**Dead End Signals:**
- Unfalsifiable at Stage 4 (purely definitional)
- No structure emerges at Stage 2 (just a list)
- Examples don't map at Stage 3 (framework wrong)
- No action implications at Stage 6 (only descriptive)

**When to abandon:**
- After 3+ refinement loops with no progress
- When simpler existing concept does same work
- When falsification is impossible in principle
- When user loses conviction

**How to abandon gracefully:**
- "This might be a distinction without a difference"
- "Existing concept X might be sufficient"
- "The insight is [extracted value] even if framework doesn't hold"

---

## Concept Types & Development Paths

### Type 1: Taxonomic (Classification)

**Path:** Examples → Pattern → Dimensions → Zones  
**Output:** Grid or categorical framework  
**Example:** Tractability Grid (Context × Complexity)

**Key stages:** 2 (Dimensionalization), 3 (Mapping), 4 (Testing)

---

### Type 2: Process (Sequential)

**Path:** Current state → Transitions → Stages  
**Output:** Maturity model or process flow  
**Example:** SOP states (fiction → nonexistent → accurate)

**Key stages:** 1 (Articulation), 2 (Structure as stages), 6 (Doctrine as transitions)

---

### Type 3: Causal (Explanatory)

**Path:** Puzzle → Hypothesis → Test → Refinement  
**Output:** Explanatory model with mechanisms  
**Example:** Why 95% of implementations fail

**Key stages:** 1 (Hypothesis), 4 (Testing), 5 (Refinement with alternatives)

---

### Type 4: Diagnostic (Decision)

**Path:** Question → Factors → Tree → Recommendations  
**Output:** Decision tree or if-then heuristics  
**Example:** When to document tacit knowledge

**Key stages:** 2 (Factor identification), 4 (Operationalization), 6 (Doctrine)

---

### Type 5: Constraint (Strategic)

**Path:** Goal → Barriers → Interactions → Doctrine  
**Output:** Constraint map with strategic implications  
**Example:** Six constraints on Anthropic's mission

**Key stages:** 2 (Constraint identification), 5 (Interaction effects), 6 (Priority doctrine)

---

## Quality Checks by Stage

**Stage 1:** Can state in 1-2 sentences? Distinct from existing concepts?  
**Stage 2:** Are dimensions independent? Clearly defined? Observable?  
**Stage 3:** Do examples clearly fit? Are boundaries explicit?  
**Stage 4:** Is it falsifiable? Can others apply consistently?  
**Stage 5:** Are tensions acknowledged? Tradeoffs explicit?  
**Stage 6:** Are implications actionable? Prioritization clear?  
**Stage 7:** Can non-expert understand? Apply without assistant?

---

## Facilitation Principles

### Early Stages (0-2): Patience
- Let it be messy
- Don't force structure prematurely
- Examples before theory
- Questions > Answers

### Middle Stages (3-5): Rigor
- Demand falsifiability
- Challenge with edge cases
- Surface tensions honestly
- Test against alternatives

### Late Stages (6-7): Clarity
- Make actionable
- Simplify without loss
- Prepare for teaching
- Enable independence

---

## Integration with Other Skills

**With `research-to-essay`:**
- Forged concept → Deep dive research → Essay explaining framework

**With `strategy-to-artifact`:**
- Forged concept → Visual framework → Deck or one-pager

**With `prose-polish`:**
- Concept description → Prose polish → Clear explanation

**Workflow:**
- `concept-forge` → crystallize idea
- `research-to-essay` → ground in evidence
- `strategy-to-artifact` → make shareable
- `prose-polish` → ensure clarity
