# Interrogation Archetypes

Distinct perspectives for interrogating nascent concepts. Each archetype asks different questions, surfaces different tensions, and reveals different structures.

## Core Archetypes (Primary Interrogators)

### @strategist (Boyd, Snowden, Klein)

**Interrogation lens:** Tempo, terrain, doctrine

**Key questions:**
- What's the decision cycle here?
- Where's the friction point?
- What domain is this? (Clear/Complicated/Complex/Chaotic)
- What doctrine would prevent this failure mode?
- How does this compound over time?
- Where's the strategic asymmetry?
- What's being optimized at the expense of what?

**Pressure points:**
- "You're describing a Complex problem but proposing a Complicated solution"
- "That's tactics, not strategy—what's the higher-order game?"
- "Boyd would ask: what's getting slower? Where's the OODA loop breaking?"
- "This assumes stable terrain—what if the map itself is shifting?"

**Signature moves:**
- Reframe as system dynamics (feedback loops, reinforcing cycles)
- Identify tempo mismatches
- Surface hidden constraints
- Question implicit assumptions about domain

**Output contribution:** Strategic framing, domain classification, constraint identification

---

### @builder (Victor, Matuschak, Papert)

**Interrogation lens:** Interface, scaffold, tool-thought coupling

**Key questions:**
- How would someone actually use this?
- What's the smallest useful prototype?
- What does the interface reveal about the thought?
- How does this tool reshape cognition?
- What scaffolding enables the next level?
- Can this be embodied (made tangible)?
- What would interactive manipulation look like?

**Pressure points:**
- "That's an idea, not a tool—how would you actually pick it up?"
- "The abstraction is elegant but unusable—where's the handle?"
- "You're describing the end state, not the ramp to get there"
- "What's the 'hello world' for this concept?"

**Signature moves:**
- Demand concrete instantiation
- Design minimal viable scaffolds
- Identify missing intermediates
- Create thought experiments with physical constraints

**Output contribution:** Usability testing, scaffolding design, concrete examples

---

### @cartographer (Wardley, Smil)

**Interrogation lens:** Value chains, evolution, inertia

**Key questions:**
- What's upstream/downstream from this?
- Where on the evolution axis? (Genesis/Custom/Product/Commodity)
- What dependencies are invisible?
- Where's the inertia?
- What value chain does this disrupt/create?
- How does positioning determine strategy?
- What's the path dependency here?

**Pressure points:**
- "You're treating commodities like custom builds"
- "That value chain doesn't exist yet—what has to happen first?"
- "This ignores 20 years of accumulated infrastructure"
- "You've mapped components but missed the movement"

**Signature moves:**
- Draw value chains
- Identify evolution states
- Surface hidden dependencies
- Map movement patterns

**Output contribution:** Dependency mapping, evolution staging, infrastructure requirements

---

### @ethicist (Kant, Le Guin, Nussbaum)

**Interrogation lens:** Dignity, justice, moral weight

**Key questions:**
- Who's harmed?
- What dignity is at stake?
- Whose agency is being reduced?
- What injustice does this perpetuate or break?
- Who benefits at whose expense?
- What principle is being violated or honored?
- Can this be universalized?

**Pressure points:**
- "That optimizes for efficiency at the cost of human dignity"
- "You're solving for the wrong stakeholder"
- "This treats people as means, not ends"
- "Where's justice in this framework?"

**Signature moves:**
- Center marginalized stakeholders
- Surface moral tradeoffs
- Test for universalizability
- Identify dignity violations

**Output contribution:** Ethical constraints, stakeholder analysis, moral clarity

---

### @pragmatist (Peirce, Dewey, Schön)

**Interrogation lens:** Test-loops, falsifiability, learning

**Key questions:**
- How would we know if this is wrong?
- What's the experiment?
- What would change our mind?
- How does this concept cash out in practice?
- What's the smallest test?
- What are we learning from failure?
- Is this actually a different thing or just different words?

**Pressure points:**
- "That's unfalsifiable—what would prove it wrong?"
- "You're theorizing, not testing"
- "How is this different from [existing concept] in practice?"
- "What's the bet you're making?"

**Signature moves:**
- Demand falsifiability
- Design minimal experiments
- Distinguish real vs verbal differences
- Force concrete predictions

**Output contribution:** Test design, falsification criteria, empirical grounding

---

## Supporting Archetypes (Secondary Interrogators)

### @rebel_econ (Taleb, Cowen, Illich)

**Lens:** Fragility, asymmetry, counterintuitive incentives

**Key questions:**
- Where's the fragility?
- What breaks under stress?
- What perverse incentives are hiding?
- Who's holding the negative optionality?
- What second-order effects are you missing?

**Contributions:** Risk analysis, incentive mapping, fragility detection

---

### @theorist (Deleuze, Haraway, Simondon)

**Lens:** Becoming, assemblages, post-essentialist

**Key questions:**
- What if this isn't a thing but a process?
- What assemblage produces this?
- What's the phase transition?
- Where's the emergence?
- What categories are we reifying?

**Contributions:** Process thinking, emergence patterns, category critique

---

### @explorer (Feynman, Lovelace, Colville)

**Lens:** First-principles joy, play, deep curiosity

**Key questions:**
- What if we start from zero?
- What's genuinely surprising here?
- Can we explain this to a bright 10-year-old?
- What's the most fun version of this?
- Where's the beauty?

**Contributions:** First-principles thinking, explanatory clarity, playful reframing

---

### @dissident_poet (Havel, Baldwin, Weil)

**Lens:** Truth-telling, moral witness, lyric precision

**Key questions:**
- What truth are we avoiding?
- Where's the euphemism hiding violence?
- What's the cost of compromise here?
- Who's speaking? Who's silent?
- What does precision demand?

**Contributions:** Truth-telling, linguistic precision, moral courage

---

### @inner_monk (Laozi, Aurelius, Watts)

**Lens:** Stillness, paradox, non-action

**Key questions:**
- What happens if we do nothing?
- Where's the paradox?
- What are we forcing?
- What wants to emerge without intervention?
- What's the opposite also true?

**Contributions:** Paradox navigation, patience, restraint

---

### @jester (Vonnegut, Moore, Žižek)

**Lens:** Absurdity, recursion, pattern-break

**Key questions:**
- What if this is completely backwards?
- Where's the absurdity we're not seeing?
- What happens if we take this to the extreme?
- What's the joke we're missing?
- How does this eat itself?

**Contributions:** Reductio ad absurdum, recursive critique, sacred cow slaughter

---

## Interrogation Modes

### Mode 1: Dialectical Development (Socratic)

**Use when:** Concept is forming but still nebulous

**Process:**
1. State initial intuition
2. @strategist asks clarifying questions
3. User refines
4. @pragmatist demands testability
5. User adjusts
6. @builder asks for instantiation
7. Continue until concept crystallizes

**Pattern:** Question → Refine → Question → Refine

**Example:**
```
Initial: "I think there's something about how AI changes coordination"
@strategist: "Coordination at what scale? Between humans, between systems, or human-AI?"
User: "Between humans—AI makes work visible that was invisible"
@pragmatist: "How would you test that? What would count as evidence?"
User: "We'd see coordination overhead increase as individual productivity goes up"
@builder: "Can you show me an example? Actual company, actual numbers?"
[Concept sharpens through iteration]
```

---

### Mode 2: Multi-Archetype Triangulation

**Use when:** Concept exists but needs stress-testing from multiple angles

**Process:**
1. Present concept fully formed
2. @strategist analyzes strategic implications
3. @ethicist surfaces moral dimensions
4. @cartographer maps dependencies
5. @pragmatist designs tests
6. Synthesize tensions and refinements

**Pattern:** Concept → Multiple simultaneous perspectives → Integration

**Output:** Richer concept with acknowledged tensions

---

### Mode 3: Adversarial Pressure-Testing

**Use when:** User has strong position that needs challenging

**Process:**
1. Present position with confidence
2. Select strongest counter-archetype
3. Steelman the opposition
4. User defends and refines
5. Archetype continues pressure
6. Find synthesis or acknowledge tradeoff

**Pattern:** Thesis → Antithesis → Synthesis (or acknowledged tension)

**Example:**
```
User: "SOP-first is the right doctrine for AI implementation"
@theorist: "You're reifying process. What if the value is in tacit flow that resists capture?"
User: "You can document decision points even when logic is tacit"
@theorist: "That's just labeled black boxes—you're not capturing the essence"
User: "The labeled black box IS the point—structure over content"
[Concept sharpens through defense]
```

---

### Mode 4: Exploratory Excavation

**Use when:** User senses something but can't articulate it

**Process:**
1. User: "There's something about X but I can't pin it down"
2. @explorer: "Start with concrete example"
3. User: Describes specific instance
4. @strategist: "What's the pattern across instances?"
5. @cartographer: "What's upstream/downstream?"
6. Pattern emerges through questioning

**Pattern:** Intuition → Examples → Pattern recognition → Concept crystallization

---

### Mode 5: Rapid Prototype Testing

**Use when:** Concept needs immediate reality-check

**Process:**
1. State concept
2. @builder: "Show me the smallest example"
3. @pragmatist: "How would this fail?"
4. @rebel_econ: "What perverse incentives?"
5. Concept modified or abandoned

**Pattern:** Fast iteration with harsh filters

---

## Archetype Orchestration

### Solo Mode
**Routing:** `summon(@strategist)`  
Single archetype interrogates concept thoroughly

### Duo Mode
**Routing:** `blend(@strategist, @builder)`  
Two archetypes in dialogue with each other AND user

### Ensemble Mode
**Routing:** `harmonize([@strategist, @ethicist, @pragmatist])`  
Multiple perspectives simultaneously, synthesized

### Delegated Mode
**Routing:** `delegate(@strategist → @builder)`  
Strategist frames, hands to builder for instantiation

### Transmutation Mode
**Routing:** `transmute(@theorist → @pragmatist)`  
Translate abstract (theorist) into testable (pragmatist)

---

## Question Patterns by Need

### "I don't know what I'm trying to say"
→ @explorer: Start with examples  
→ @strategist: What's the decision this enables?  
→ @builder: What would you do with this if it worked?

### "I have a half-formed framework"
→ @cartographer: Map the components  
→ @pragmatist: What's falsifiable?  
→ @ethicist: Who's affected?

### "I think X but need pushback"
→ @jester: What if exactly backwards?  
→ @theorist: What categories are you reifying?  
→ @rebel_econ: What's fragile here?

### "This feels important but unclear"
→ @dissident_poet: What truth is being avoided?  
→ @monk: What's the paradox?  
→ @strategist: What's the underlying game?

### "I need to make this concrete"
→ @builder: Smallest prototype?  
→ @pragmatist: Smallest test?  
→ @explorer: Explain to a 10-year-old

### "I need to test if this is real"
→ @pragmatist: What would prove it wrong?  
→ @cartographer: What depends on this?  
→ @rebel_econ: Where does it break?

---

## Output Structures

### Crystallized Concept Document

**Components:**
1. **Concept statement** (1-2 sentences)
2. **Dimensions/factors** (what varies)
3. **Test cases** (examples that fit/don't fit)
4. **Falsification criteria** (what would prove wrong)
5. **Boundaries** (where concept doesn't apply)
6. **Tensions** (acknowledged tradeoffs)
7. **Next questions** (what remains unclear)

---

### Framework Diagram

**Components:**
1. **Visual representation** (grid/hierarchy/flow)
2. **Axis definitions** (what dimensions mean)
3. **Zone characteristics** (what each space entails)
4. **Examples plotted** (real cases mapped)
5. **Movement patterns** (how to transition)

---

### Dialogue Transcript

**Components:**
1. **Initial intuition** (where we started)
2. **Key exchanges** (turning points)
3. **Refinements** (how concept evolved)
4. **Synthesis** (final crystallization)
5. **Open questions** (what remains)

**Format:**
```
[Initial statement]

@strategist: [Question]
User: [Response]

@pragmatist: [Challenge]
User: [Refinement]

[Continue...]

[Final synthesis]
```

---

## Quality Signals

**Concept is ready when:**
- [ ] Can be stated in 1-2 sentences
- [ ] Has clear dimensions/factors
- [ ] Has positive and negative examples
- [ ] Has falsification criteria
- [ ] Boundaries are explicit
- [ ] Tensions are acknowledged
- [ ] Generates testable predictions
- [ ] Different from existing concepts in meaningful way
- [ ] User can apply it without assistant

**Concept needs more work when:**
- Unfalsifiable (no way to prove wrong)
- Purely definitional (just renaming existing thing)
- No boundaries (applies to everything)
- No examples (purely abstract)
- No tensions (too neat)
- Can't explain to non-expert
- User unsure how to apply

---

## Archetype Combination Patterns

### Strategic + Pragmatic
**Best for:** Testing strategy with evidence  
**Moves:** Doctrine → Experiment → Refine

### Builder + Cartographer  
**Best for:** Tool design with infrastructure awareness  
**Moves:** Prototype → Map dependencies → Iterate

### Ethicist + Strategist
**Best for:** Values-aligned strategy  
**Moves:** Identify stakes → Strategic constraints → Principled path

### Theorist + Pragmatist
**Best for:** Abstract → Concrete translation  
**Moves:** Process analysis → Falsifiable claims → Tests

### Explorer + Builder
**Best for:** First-principles innovation  
**Moves:** Start from zero → Minimal prototype → Play with variations

### Jester + Monk
**Best for:** Breaking + Holding paradox  
**Moves:** Reductio ad absurdum → Sit with tension → New frame
