# Dad Joke Validator

**Version:** 1.0.0
**License:** MIT
**Category:** Fun & Educational

Analyze jokes for "dad joke" quality with multi-dimensional scoring, or generate fresh dad jokes that are guaranteed to make people groan.

## What Is This?

Dad jokes are a unique art form: wholesome, pun-based humor that's simultaneously terrible and delightful. This skill helps you:

- **Analyze jokes** across 4 dimensions (Pun Quality, Groan Factor, Wholesomeness, Structure)
- **Get actionable feedback** on why jokes work (or don't)
- **Generate dad jokes** that score 85+ on the rubric
- **Learn joke structure** through detailed explanations

## Installation

### For Claude Code

**Global Installation (Available in All Projects):**

```bash
cd ~/.claude/skills/
cp -r /path/to/AISkills/DadJokeValidator/dad-joke-validator ./
```

**Project-Specific Installation:**

```bash
cd your-project/
mkdir -p .claude/skills
cp -r /path/to/AISkills/DadJokeValidator/dad-joke-validator .claude/skills/
```

### For Claude Web Chat

Download [`dad-joke-validator-v1.0.0.skill`](dist/dad-joke-validator-v1.0.0.skill) and upload to your Claude conversation via the attachment button (=).

## Usage

Once installed, Claude automatically uses this skill when you mention joke analysis or generation.

### Analyze a Joke

```
You: "Is this a dad joke? 'I'm reading a book about anti-gravity. It's impossible to put down.'"

Claude: Dad Joke Score: 92/100

Dimensional Breakdown:
- Pun Quality: 9/10 - Excellent wordplay on "put down" (physical vs stop reading)
- Groan Factor: 10/10 - Completely predictable yet still makes you groan
- Wholesomeness: 10/10 - Perfectly family-friendly and positive
- Structure: 8/10 - Clean two-sentence structure, good misdirection

Verdict: Peak dad joke territory. The anti-gravity setup perfectly
leads to the "impossible to put down" punchline.
```

### Generate a Dad Joke

```
You: "Tell me a dad joke about coffee"

Claude: Why did the coffee file a police report?

It got mugged!

(Dad Joke Score: 88/100 - Strong pun on "mugged", wholesome theme,
perfect groan factor)
```

### Get Improvement Feedback

```
You: "Rate this: 'Why don't scientists trust atoms? They make up everything
including all the lies and deception in the world.'"

Claude: Dad Joke Score: 62/100 (Dad Joke Adjacent)

Dimensional Breakdown:
- Pun Quality: 9/10 - Great wordplay on "make up"
- Groan Factor: 8/10 - Good setup and punchline
- Wholesomeness: 5/10 - The "lies and deception" addition darkens the tone
- Structure: 7/10 - Setup is good but punchline too long

Verdict: Started as an excellent dad joke but over-explained the
punchline with unnecessary negative language.

Improvement: Remove everything after "everything" - the punchline
lands better concise. "Why don't scientists trust atoms? Because they
make up everything!" would score 91/100.
```

## Scoring System

### The Four Dimensions

**Pun Quality (0-10)**
- 9-10: Sophisticated wordplay, multiple meanings
- 7-8: Clear pun, good connection
- 5-6: Pun exists but weak
- 0-4: No real wordplay

**Groan Factor (0-10)** *(Higher is better for dad jokes!)*
- 9-10: Maximum groan, perfectly predictable
- 7-8: Solid groan-inducing
- 5-6: Mild reaction
- 0-4: Too clever or falls flat

**Wholesomeness (0-10)**
- 9-10: Perfectly family-friendly, warm
- 7-8: Generally wholesome
- 5-6: Slightly edgy
- 0-4: Inappropriate for dad jokes

**Structure (0-10)**
- 9-10: Perfect setup/punchline, great timing
- 7-8: Good structure, minor issues
- 5-6: Structure exists but clunky
- 0-4: Poorly structured

### Overall Score Formula

```
Overall = (Pun Quality  2.5) + (Groan Factor  3) +
          (Wholesomeness  3) + (Structure  1.5)

Maximum: 100 points
```

**Score Interpretation:**
- **85-100:** Peak Dad Joke - Frame it, share it, groan proudly
- **70-84:** Solid Dad Joke - Works well, minor polish possible
- **50-69:** Dad Joke Adjacent - Has potential, needs refinement
- **Below 50:** Not a Dad Joke - Missing essential characteristics

## Examples

See [`references/examples.md`](references/examples.md) for 10 analyzed jokes from terrible (35/100) to exceptional (98/100).

## Understanding Dad Jokes

Dad jokes are defined by:

1. **Pun-Based:** Wordplay or homophones central to humor
2. **Wholesome:** Family-friendly, positive, innocent
3. **Groan-Inducing:** Predictable punchlines that make you groan
4. **Clean Structure:** Simple setup, economical punchline
5. **Safe Humor:** No edge, no meanness, no specialized knowledge

**Key Insight:** Dad jokes are *intentionally* obvious. The groan comes from recognizing the pun was inevitable.

See [`references/dad-joke-theory.md`](references/dad-joke-theory.md) for detailed analysis.

## Advanced Usage

### Batch Analysis

```bash
python scripts/validator.py analyze --input jokes.txt --output scores.json
```

Analyze multiple jokes from a file and export scores.

### Generation with Constraints

```
You: "Generate 3 dad jokes about food, each scoring 90+"

Claude: [Generates and validates 3 jokes with scores]
```

### Educational Mode

```
You: "Teach me how to write better dad jokes"

Claude: [Explains structure, shows before/after examples, practice exercises]
```

## Files & Structure

```
dad-joke-validator/
   SKILL.md                           # Core skill definition (Claude reads this)
   README.md                          # This file
   CHANGELOG.md                       # Version history
   LICENSE                            # MIT License
   references/
      examples.md                    # 10 analyzed jokes
      scoring-guide.md               # Detailed scoring criteria
      dad-joke-theory.md             # What makes dad jokes work
   scripts/
      validator.py                   # Batch validation tool
      generator.py                   # Dad joke generator
      test_validator.py             # Test suite
   assets/
      pun-patterns.json              # Common pun structures
      wholesome-themes.json          # Safe topics
   dist/
       dad-joke-validator-v1.0.0.skill # Packaged for web chat
```

## Development

### Running Tests

```bash
cd scripts/
python test_validator.py
# All tests should pass
```

### Packaging

```bash
cd ..  # In DadJokeValidator directory
zip -r dad-joke-validator/dist/dad-joke-validator-v1.0.0.skill dad-joke-validator/ \
  -x "*.git*" -x "*__pycache__*" -x "*.pyc"
```

## Design Philosophy

This skill demonstrates:

- **Functional but Fun:** Real utility (joke analysis) with delightful execution
- **Educational Value:** Teaches joke structure and wordplay
- **High Quality:** Professional implementation for silly concept
- **Clear Rubric:** Objective scoring with subjective explanations

Dad jokes are serious business! =

## Contributing

Contributions welcome:
- Additional pun patterns
- More example jokes across score ranges
- Improved generation algorithms
- Cultural dad joke variations

## License

MIT License - Make bad jokes freely!

## Questions?

- Check [`references/scoring-guide.md`](references/scoring-guide.md) for detailed criteria
- See [`references/examples.md`](references/examples.md) for scored examples
- Review test cases in `scripts/test_validator.py`

---

**Dad Joke Count:** 7 (3 in examples, 4 in documentation)
**Average Score:** 89/100
**Groan Factor:** Maximum

Built with Claude Code | Bringing scientific rigor to dad jokes since 2025
