# Nano Banana Pro - Example Prompts

Copy-paste ready prompts organized by use case.

## Marketing & Business

### Social Media Graphics

```
Modern Instagram post announcing a summer sale,
bold text "50% OFF" in white against gradient pink-to-orange background,
floating shopping bags and confetti,
clean minimalist design,
square format 1:1 ratio
```

### Product Mockup

```
Premium skincare bottle on marble surface,
soft studio lighting with gentle shadows,
water droplets for freshness,
eucalyptus leaves as props,
luxury cosmetic photography,
clean white background, 4K
```

### Business Card Design

```
Elegant business card for "AURORA DESIGN STUDIO",
white card with gold foil accents,
minimalist modern typography,
subtle geometric pattern,
laying on dark slate surface,
product photography style
```

## Web & UI Design

### App Screenshot Mockup

```
iPhone 15 Pro displaying a fitness tracking app,
floating at slight angle,
dark mode UI with neon green accents,
clean gradient background purple to blue,
soft shadow beneath device,
marketing mockup style
```

### Website Hero Image

```
Abstract 3D shapes floating in space,
glass morphism spheres and cubes,
soft purple and teal gradient background,
modern tech aesthetic,
subtle grain texture,
website hero section style, wide format
```

### Icon Set

```
Set of 6 app icons for a productivity suite,
consistent rounded square shape,
gradient backgrounds in blue, purple, green, orange, pink, teal,
simple white line icons for: calendar, tasks, notes, timer, goals, stats,
iOS style, clean modern design
```

## Art & Illustration

### Fantasy Scene

```
Ancient dragon perched on mountain peak at twilight,
massive scaled creature with iridescent wings,
medieval castle in distant valley below,
dramatic storm clouds with lightning,
epic fantasy concept art,
cinematic composition,
highly detailed, 4K
```

### Children's Book Illustration

```
Friendly fox and rabbit having a tea party in forest clearing,
whimsical watercolor style,
soft pastel colors,
dappled sunlight through trees,
mushrooms and flowers around them,
storybook illustration,
warm and inviting
```

### Portrait Art

```
Portrait of an elderly fisherman,
weathered face with deep smile lines,
salt-and-pepper beard,
wearing worn cable-knit sweater,
coastal village background,
oil painting style,
Rembrandt lighting,
rich warm tones
```

## Photography Style

### Landscape

```
Misty morning in Japanese bamboo forest,
tall bamboo stalks disappearing into fog,
stone path with moss,
soft diffused light,
serene and peaceful atmosphere,
fine art nature photography,
4K resolution
```

### Street Photography

```
Rainy night in Tokyo,
neon signs reflecting on wet pavement,
lone figure with umbrella,
steam rising from street vendor,
cinematic cyberpunk aesthetic,
35mm film grain,
moody atmospheric
```

### Food Photography

```
Artisan sourdough bread fresh from oven,
crusty golden exterior with flour dusting,
steam rising from torn piece,
rustic wooden cutting board,
linen napkin, butter dish nearby,
morning window light,
editorial food photography
```

## Technical & Diagrams

### Infographic

```
Clean infographic showing "5 Steps to Productivity",
numbered circles 1-5 connected by flowing line,
each step with simple icon,
modern flat design,
blue and white color scheme,
professional business style,
clear readable text
```

### Process Diagram

```
Circular workflow diagram for software development,
6 stages: Plan, Design, Develop, Test, Deploy, Monitor,
connected by arrows,
each stage in different color,
isometric 3D style icons,
clean white background,
corporate presentation quality
```

### Architecture Blueprint

```
Modern minimalist house floor plan,
open concept living space,
3 bedrooms, 2 bathrooms,
clean architectural drawing style,
measurements and room labels,
blue lines on white background,
professional blueprint aesthetic
```

## Character Design

### Game Character

```
Female warrior character design,
full body turnaround sheet,
front, side, and back views,
ornate silver armor with blue accents,
long braided white hair,
confident stance,
fantasy RPG style,
concept art quality
```

### Mascot Design

```
Friendly robot mascot for tech startup,
rounded cute design,
big expressive digital eyes,
antenna with glowing tip,
blue and white color scheme,
waving pose,
vector illustration style,
suitable for logo use
```

## Editing Examples

### Style Transfer

**Original prompt:**
```
Upload photo of city street
```

**Edit instruction:**
```
Transform into Van Gogh Starry Night style,
swirling brushstrokes in sky,
vibrant blues and yellows,
impressionist interpretation,
maintain basic composition
```

### Background Change

**Edit instruction:**
```
Replace background with tropical beach sunset,
warm orange and pink sky,
palm tree silhouettes,
calm ocean water,
maintain subject lighting consistency
```

### Season Change

**Edit instruction:**
```
Transform scene to winter:
add snow covering ground and rooftops,
frost on windows,
bare trees,
overcast sky,
cool blue color grading,
visible breath on any people
```

## Multi-Image Composition

### Product Lifestyle

```
Compose these reference images into lifestyle scene:
- Image 1: Coffee mug product
- Image 2: Cozy living room
- Image 3: Book and blanket

Result: Cozy reading nook scene with coffee mug on side table,
book open on lap, soft blanket,
warm morning light,
lifestyle product photography
```

### Character in Environment

```
Place character from history:0 into this environment:
- Maintain character appearance exactly
- Position them naturally in scene
- Match lighting and style
- Add appropriate shadows
```

## Tips for These Examples

1. **Modify freely** - These are starting points, customize for your needs
2. **Add specifics** - The more detail, the better results
3. **Iterate** - Use `continue_editing` to refine
4. **Combine styles** - Mix elements from different examples
5. **Reference history** - Use `history:N` to maintain consistency
