# Remediation Strategies (v2)

Systematic approaches to elevating writing effectiveness using two-phase remediation.

## Philosophy Shift (v2)

**Old approach:** Three Pillars (Rhythm → Commitment → Voice) in one pass
**New approach:** Two Phases (Structure → Style) with separate concerns

**Why the change:** Per Gemini critique, attention decay in single-pass remediation means later fixes forget earlier constraints. Splitting into phases improves quality.

---

## Two-Phase Remediation Framework

### Phase 1: Structural (The Editor)
Fix **logic and authority** before touching style.

Focus: Coherence and Authority dimensions
Goal: Sound argument, demonstrated expertise
Order: Coherence Pass → Authority Pass

### Phase 2: Stylistic (The Writer)
Now refine **rhythm, commitment, and voice**.

Focus: Craft and Voice dimensions
Goal: Engaging, distinctive prose
Order: Rhythm Pass → Commitment Pass → Voice Pass

**Why this order:** A polished logical fallacy is still a fallacy. Fix the bones before fixing the skin.

---

## Surgical Fixes (Quick Wins)

For users who want targeted improvements without the full two-phase process:

### 5-Minute Fixes (Immediate Impact)

| Fix | Find | Replace With |
|-----|------|--------------|
| **Kill "delve"** | "delve into," "delve deeper" | "explore," "examine," or just cut |
| **Kill "robust"** | "robust solution/system" | "reliable," "proven," or specific benefit |
| **Kill "leverage"** | "leverage this/that" | "use," "apply," or specific action |
| **Kill landscape** | "in today's X landscape" | Specific context or just cut opening |
| **Remove hedge stacks** | "might potentially somewhat" | Single hedge or commit to claim |
| **Fix impersonal openings** | "It is important to note," "It should be noted," "It is worth noting" | State the important thing directly |

### 10-Minute Fixes (Structural Quick Hits)

1. **Sentence Variance Injection:**
   - Find your longest sentence → add a 4-word sentence after it
   - Find three same-length sentences in a row → vary one dramatically

2. **Transition Audit:**
   - Search: "Moreover," "Furthermore," "Additionally"
   - For each: delete and see if paragraph still flows
   - If yes: leave deleted. If no: rewrite for actual connection

3. **Authority Spot-Check:**
   - Find "Research shows" or "Studies indicate"
   - Either: add specific citation, OR demonstrate the knowledge instead

4. **Opening Surgery:**
   - If opening matches "In today's [X] landscape/environment/world" → rewrite with specific hook
   - First sentence should earn attention, not announce topic

### When to Use Quick Wins vs Full Process

- **Quick Wins:** Polishing drafts, tight deadlines, minor cleanup
- **Full Two-Phase:** Significant rewrites, quality-critical content, learning the craft

---

## PHASE 1: STRUCTURAL REMEDIATION

### Coherence Pass

Fix logical flow, remove decorative elements, ensure transitions are earned.

#### Problem: Decorative Specificity
**Symptom:** Details that look specific but don't advance understanding

**Detection:** Ask "What depends on this detail?"

**Fix - Functional Test:**
1. Find every specific detail (date, name, number, place)
2. Ask: "Does anything else in the text depend on this?"
3. If NO: Remove or replace with functional detail
4. If YES: Keep

**Example Before:**
"Margaret, who'd lived at 2847 Oleander Drive for thirty-seven years, noticed the okra hadn't bloomed since March 14th."

**Example After:**
"Margaret had gardened here long enough to know when something was wrong. The okra should have bloomed weeks ago."

**Why better:** Duration and wrongness are functional; exact address and date were decoration.

#### Problem: Causal Incoherence
**Symptom:** Claimed cause-effect that doesn't hold

**Detection:** For every "because/due to/from/since," ask "Does Y actually follow from X?"

**Fix - Verify or Remove:**
1. Find causal claims
2. Test logic: Is this causation or correlation? Does it actually follow?
3. If invalid: Remove claim or provide actual mechanism

**Example Before:**
"Her hands were cracked from decades of teaching calculus."

**Example After:**
"Her hands were cracked—the garden soil, the endless dishes, the dry winters."

#### Problem: Floating Claims
**Symptom:** Bold assertions without grounding

**Detection:** For each strong claim, ask "What earned this?"

**Fix - Ground or Qualify:**
1. Find unearned claims
2. Option A: Add grounding (evidence, experience, logic)
3. Option B: Reduce claim strength to match evidence

**Example Before (floating):**
"Digital transformation fails when companies buy expensive software and hope for magic."

**Example After (grounded):**
"I've seen digital transformation fail at four companies now. Each time, same pattern: expensive software, vague goals, no change to workflows. The software wasn't the problem."

#### Problem: Mechanical Transitions
**Symptom:** "Moreover," "Furthermore," "Additionally" connecting unrelated ideas

**Detection:** Remove the transition word. Does the connection still make sense?

**Fix - Earn or Remove:**
1. Find formal transitions
2. Remove the transition word
3. If ideas no longer connect: rewrite for actual logical flow
4. If they still connect: leave transition out

**Example Before:**
"The system improved efficiency. Moreover, it reduced errors."

**Example After:**
"The system improved efficiency by catching errors before they compounded."

### Authority Pass

Demonstrate expertise rather than claiming it.

#### Problem: Delegated Authority
**Symptom:** "Research shows," "Best practices," institutional voice

**Fix - Earn or Cite:**
1. Have a specific source? Cite it properly
2. Don't have a source? Demonstrate knowledge instead

**Example Before:**
"Research shows that exercise improves mood."

**Example After (cited):**
"A 2019 meta-analysis (Schuch et al.) found exercise as effective as antidepressants for mild depression."

**Example After (demonstrated):**
"Exercise improves mood. Run for thirty minutes and notice how the mental fog lifts. There's a reason every therapist recommends it."

#### Problem: Institutional Hiding
**Symptom:** "It is recommended," "It should be noted," passive authority

**Fix - Own the Voice:**
Replace institutional passive with active speaker.

**Example Before:**
"It is recommended that users update their passwords regularly."

**Example After:**
"Update your password every 90 days. Here's why that matters..."

#### Problem: Generic Expertise
**Symptom:** Stereotypes as insider knowledge

**Detection:** Could anyone write this, or only someone with real experience?

**Fix - Add Insider Details:**
1. Find generic expertise claims
2. Add specific details only someone experienced would know
3. Include tradeoffs, limitations, edge cases

**Example Before:**
"The cubicle smelled like old coffee and desperation."

**Example After:**
"The cubicle still had the same laminate desk from 2008—the one with the keyboard tray that stuck, that everyone learned to jiggle just so."

#### Problem: Missing Stakes
**Symptom:** No skin in the game, no consequences

**Fix - Add Vulnerability:**
1. Show what you risked to know this
2. Acknowledge what you got wrong
3. Explain what you're uncertain about and why

**Example Before:**
"Leaders should listen to their teams."

**Example After:**
"I learned to listen after losing my best engineer. She left because I'd overridden her technical judgment three times. She was right each time. That's on me."

---

## PHASE 2: STYLISTIC REMEDIATION

### Rhythm Pass

Fix mechanical patterns while serving meaning.

#### Problem: Uniform Sentence Length
**Symptom:** All sentences 20-25 words, robotic cadence

**Fix - Aggressive Variation:**
Create extremes that serve meaning:
- Short punches (3-7 words) for emphasis
- Long explorations (35+ words) for complexity
- Varied middle for flow

**Example Before:**
"The implementation of the new system requires careful planning. This planning must account for multiple stakeholders. The stakeholders have different needs and priorities."

**Example After:**
"The new system needs planning. Careful planning—the kind that accounts for stakeholders with wildly different needs, priorities, and levels of technical literacy—not the kind you sketch on a napkin."

#### Problem: Uniform Information Density
**Symptom:** Every paragraph equally packed (Gemini critique)

**Fix - Strategic Density:**
1. Dense sections for important concepts
2. Sparse sections for emphasis or rest
3. Vary the ratio paragraph by paragraph

**Example:** After dense technical explanation, add: "That's the core of it." Then continue.

### Commitment Pass

Add stakes while classifying hedges correctly.

#### Problem: Cowardly Hedges
**Symptom:** "Some might say," "It could be argued," "somewhat"

**Detection:** Is this avoiding opinion or expressing genuine uncertainty?

**Fix - Commit or Explain:**
1. Find hedges
2. Classify: Cowardly (opinion avoidance) or Protective (epistemic honesty)
3. Remove cowardly hedges; keep protective ones

**Cowardly (remove):**
"It could be argued that the approach has merit." → "The approach works."

**Protective (keep):**
"Early data suggests effectiveness." (genuinely uncertain)

#### Problem: False Precision
**Symptom:** "This speaks to," "This underscores," "This highlights"

**Fix - Direct Statement:**
Replace meta-commentary with the actual claim.

**Example Before:**
"This data underscores the importance of early intervention."

**Example After:**
"Early intervention matters. Mortality drops 40% when treatment starts within 6 hours."

#### Problem: Both-Sides Theater
**Symptom:** False balance on settled questions

**Fix - Proportional Treatment:**
State consensus, acknowledge dissent proportionally, move on.

**Example Before:**
"While some experts believe climate change is occurring, others dispute this claim."

**Example After:**
"Climate change is happening. 97% of climate scientists agree. A small minority disputes this, mostly funded by fossil fuel interests."

### Voice Pass

Add personality without overcorrection.

#### Problem: Missing Personality
**Symptom:** Perfect standardized English, no author visible

**Fix - Controlled Informality:**
Add personality markers calibrated to genre.

- ONE colloquialism per 200 words
- Contractions where natural
- Occasional fragment for emphasis
- One sentence that risks being "wrong"

**Avoid:** "LinkedIn Influencer" overcorrection—too aggressive, too personal, cringe

#### Problem: Olympian Neutrality
**Symptom:** No perspective, pure observation

**Fix - Perspective Injection:**
Take a position, use first person occasionally, make disputable claims.

**Example Before:**
"Different organizations use different approaches. Each has advantages and disadvantages."

**Example After:**
"Most organizations get this wrong. They choose what looks impressive on slides rather than what works in production."

#### Problem: Missing Embodiment
**Symptom:** Could be written by anything, no sense of lived experience

**Fix - Sensory Grounding:**
Add ONE moment of physical or experiential reality.

**Example Before:**
"The meeting was unproductive."

**Example After:**
"Three hours of my life I'll never get back. My coffee went cold twice."

---

## Quick Reference: Two-Phase Checklist

### Phase 1: Structural
- [ ] Decorative specificity removed?
- [ ] Causal claims verified?
- [ ] Bold claims grounded?
- [ ] Transitions earned?
- [ ] Authority demonstrated (not claimed)?
- [ ] Institutional voice replaced with speaker?
- [ ] Stakes visible?

### Phase 2: Stylistic
- [ ] Sentence variance serves meaning?
- [ ] Density varies strategically?
- [ ] Cowardly hedges removed?
- [ ] Protective hedges preserved?
- [ ] False precision eliminated?
- [ ] Voice appropriate for genre?
- [ ] Embodiment present?
- [ ] NOT overcorrected to cringe?

---

## Genre-Calibrated Remediation

### Technical Documentation
**Phase 1:** Focus on coherence—does explanation flow logically?
**Phase 2:** Light touch on voice—neutral authority is appropriate

### Business Writing
**Phase 1:** Focus on authority—demonstrate expertise, acknowledge friction
**Phase 2:** Moderate voice—professional but human

### Creative/Personal
**Phase 1:** Focus on coherence—does narrative hold together?
**Phase 2:** Heavy focus on voice—distinctive, embodied, risk-taking

---

## Pitfalls to Avoid

**Overcorrection:**
- Too much personality → "LinkedIn Influencer" cringe
- Too much specificity → data overload
- Too much informality → unprofessional

**Undercorrection:**
- Fixed rhythm but not coherence → polished nonsense
- Fixed hedges but not authority → confident emptiness
- Fixed voice but not logic → personality without substance

**Phase Mixing:**
- Don't add voice markers before fixing logic
- Don't polish sentences that shouldn't exist

---

## Quality Checks

**After Phase 1:**
- Read for logic only. Does the argument hold?
- Are all claims grounded?
- Would a hostile reader find gaps?

**After Phase 2:**
- Read aloud. Does it breathe?
- Is there surprise?
- Would you recognize this author again?

**Final Check:**
- Dimension gap diagnosis:
  - High craft + low coherence = decorative writing (Phase 1 incomplete)
  - High voice + low authority = personality without substance (authority not earned)
  - High authority + low voice = institutional but effective (maybe fine for genre)
