# Essay Structures

Narrative arc patterns for different argument types.

## Persuasive Structure: Claim → Evidence → Implications

**Use when:** Arguing for a position, challenging orthodoxy, proposing action

**Arc:**
1. **Hook** (50-100 words): Counter-intuitive observation or provocative claim
2. **Stakes** (100-150 words): Why this matters, what's at risk, current inadequacy
3. **Argument Core** (60% of essay): 
   - Main claim with supporting sub-claims
   - Evidence marshaling (data, examples, expert testimony)
   - Counter-argument acknowledgment + rebuttal
4. **Implications** (15% of essay): "If this is true, then..." + downstream effects
5. **Conclusion** (10% of essay): Reframe opening claim with new context, avoid summary

**Example spine:**
> Hook: "AI literacy programs are solving the wrong problem"  
> Stakes: Billions spent, minimal behavior change  
> Core: The issue isn't knowledge deficit but incentive misalignment  
> Implications: Suggests different intervention points  
> Conclusion: Returns to "wrong problem" with diagnostic framework  

---

## Exploratory Structure: Question → Investigation → Synthesis

**Use when:** Investigating a puzzle, mapping terrain, sense-making in complexity

**Arc:**
1. **Puzzle Introduction** (100-150 words): The question that doesn't have an obvious answer
2. **Frame Setting** (100-150 words): Why existing frames fail, what lens we'll use
3. **Investigation** (60% of essay):
   - Multiple perspectives on the question
   - Competing frameworks or explanations
   - Data/evidence from different domains
   - Emergent patterns across investigations
4. **Synthesis** (15% of essay): What the investigation reveals (not a final answer, but better question or frame)
5. **Open Questions** (10% of essay): What remains unresolved, where to look next

**Example spine:**
> Puzzle: "Why do AI tools increase individual productivity but slow down teams?"  
> Frame: Coordination costs vs. task efficiency  
> Investigation: Survey data, case studies, systems theory  
> Synthesis: Visibility paradox—tools surface work that was previously invisible  
> Open: How to redesign coordination itself  

---

## Diagnostic Structure: Problem → Anatomy → Leverage Points

**Use when:** Analyzing system failure, explaining "why X keeps happening"

**Arc:**
1. **Symptom Catalog** (100-150 words): The visible problem everyone recognizes
2. **Surface Explanations** (100-150 words): Common explanations and why they're insufficient
3. **Structural Analysis** (50% of essay):
   - Underlying dynamics producing symptoms
   - Feedback loops and reinforcing cycles
   - Mental models and assumptions
   - Historical context or path dependency
4. **Leverage Points** (20% of essay): Where intervention could shift dynamics (Meadows hierarchy)
5. **Action Implications** (10% of essay): What different actors could do given this diagnosis

**Example spine:**
> Symptoms: AI pilots fail to scale  
> Surface: "Change resistance," "lack of training"  
> Structure: Incentive misalignment + lack of shared language + legacy process inertia  
> Leverage: Change feedback loop structure, not individual behavior  
> Implications: Different playbook for transformation leaders  

---

## Narrative-Conceptual Structure: Story → Abstraction → Application

**Use when:** Teaching a framework through concrete example, making theory tangible

**Arc:**
1. **Concrete Story** (20% of essay): Specific instance told with detail
2. **Pattern Recognition** (10% of essay): "This story is an instance of..."
3. **Framework Introduction** (30% of essay): The general pattern/model/theory
4. **Multiple Applications** (30% of essay): Other domains where pattern appears
5. **Reader Transfer** (10% of essay): How to recognize and use this pattern

**Example spine:**
> Story: Specific AI transformation failure at Company X  
> Pattern: Recognition vs. production failure  
> Framework: Dreyfus model of skill acquisition  
> Applications: Similar pattern in other capability builds  
> Transfer: Diagnostic questions reader can ask  

---

## Synthesis Essay: Competing Views → Integration → New Frame

**Use when:** Multiple perspectives exist and need integration, not adjudication

**Arc:**
1. **Landscape Map** (15% of essay): The competing perspectives that exist
2. **Steelman Each View** (40% of essay):
   - View A and its strongest form
   - View B and its strongest form
   - View C and its strongest form
   - What each gets right
3. **Tensions & Tradeoffs** (20% of essay): Where views genuinely conflict vs. where they're orthogonal
4. **Integrative Frame** (20% of essay): Higher-order frame that preserves insight from each
5. **Application** (5% of essay): How integrated view changes practice

**Example spine:**
> Landscape: Three views on AI risk (alignment, political economy, epistemology)  
> Steelman: Each view's strongest arguments  
> Tensions: Where they genuinely disagree  
> Integration: Composite risk map  
> Application: Different interventions depending on frame  

---

## Structural Notes

### Section Transitions
- Explicit when shifting between major sections ("Having established X, now Y")
- Implicit within sections (idea flow sufficient)
- Never ornamental ("Now let us turn to...")

### Evidence Integration
- Primary sources > secondary sources > aggregators
- Recent for rapidly changing fields, classic for stable concepts
- Concrete examples before abstract claims
- Counter-evidence acknowledged, not buried

### Length Guidelines
- Substack long-form: 1500-3000 words
- LinkedIn: 150-300 words (mini-version of any structure)
- Academic: 3000-8000 words
- Executive brief: 500-1000 words
