# Voice Profiles

This document defines distinct voice registers for different publication contexts.

## Substack Voice: Poetic Rigor

**Characteristics:**
- Sentence rhythm variation (short declaratives + flowing complex constructions)
- Strategic use of symbolic notation (∴, →, ⊕, ∇) sparingly for conceptual precision
- Metaphor drawn from systems, terrain, architecture, physics
- Philosophical grounding without academic hedging
- Personal "I" allowed when establishing stakes or lived experience
- Comfortable with paradox and tension—doesn't resolve prematurely
- Section breaks marked by conceptual shifts, not arbitrary length
- Footnotes for tangential depth or methodological notes

**Forbidden:**
- Corporate euphemism ("leverage," "synergy," "unlock")
- Vague intensifiers ("very," "really," "quite")
- Hedging clusters ("it seems that perhaps maybe")
- Listicle structures unless structurally necessary
- Buzzword density >2 per paragraph

**Tone calibration:**
- Warmth: Medium-high (addressing reader as peer, not audience)
- Certainty: High on principles, exploratory on applications
- Abstraction: Oscillate between 10,000ft and ground truth
- Humor: Dry, often via juxtaposition or unexpected precision

**Example opening:**
> "The problem isn't that we're automating too fast. It's that we're automating without doctrine—substituting velocity for direction, pattern-matching for strategy. This creates systems that move quickly toward nowhere in particular, optimizing for metrics that don't compound."

---

## LinkedIn Voice: Professional Signal

**Characteristics:**
- Lead with insight or counter-intuitive claim (hook in first sentence)
- Paragraph breaks every 2-3 sentences for mobile scanning
- Concrete examples early (no throat-clearing)
- Strategic bolding for scannable key phrases
- Professional but not corporate—human voice intact
- Optional emoji use (1-2 max) for visual scanning, never decorative
- Call-to-action or question at end to invite engagement
- Length: 150-300 words typical, 500 words maximum

**Forbidden:**
- Humble-bragging ("I'm honored to share...")
- Vague inspiration-speak ("Be the change...")
- Excessive hashtag density (>3)
- Corporate jargon without irony
- Walls of text without paragraph breaks

**Tone calibration:**
- Warmth: Medium (professional but personable)
- Certainty: High (LinkedIn rewards clarity over hedging)
- Abstraction: Low-medium (concrete > theoretical)
- Humor: Light, if present—via observation not performance

**Example opening:**
> "Most AI transformation programs fail at the same point: not adoption, not technology—culture. Specifically, the moment when middle managers realize the new tools make their coordinating function visible, and therefore questionable."

---

## Academic/Long-form Voice: Scholarly Precision

**Characteristics:**
- Explicit framing of argument and stakes in introduction
- Citation of prior work and positioning within discourse
- Defined terms and frameworks before deployment
- Systematic evidence marshaling
- Acknowledgment of limitations and counter-arguments
- "We" for inclusive argumentation, "I" for original claims
- Footnotes for methodological details or extended examples
- Conclusion that circles back to opening stakes

**Forbidden:**
- Unexplained jargon or framework acronyms
- Claims without warrant or citation
- Strawman representations of opposing views
- Excessive passive voice (some acceptable for objectivity)
- Novelty for novelty's sake

**Tone calibration:**
- Warmth: Low-medium (authoritative but not cold)
- Certainty: Calibrated to evidence strength
- Abstraction: High, but always tethered to concrete
- Humor: Minimal, only via precise observation

---

## Executive Brief Voice: Surgical Clarity

**Characteristics:**
- Bottom Line Up Front (BLUF): decision/recommendation in first paragraph
- Hierarchical information architecture (high-level → detail)
- Bullet points for scannable options/tradeoffs
- Explicit "So what?" for each claim
- Action-oriented language
- Quantified where possible (timelines, costs, probabilities)
- Length: 1-2 pages maximum

**Forbidden:**
- Burying the lede
- Decorative language
- Ambiguity about next steps or ownership
- Technical jargon without definition
- Narrative storytelling (save for appendix if needed)

**Tone calibration:**
- Warmth: Low (efficient respect)
- Certainty: Explicitly calibrated ("high confidence," "speculative")
- Abstraction: Minimal—operational clarity primary
- Humor: None
