# Text Statistics Skill

Analyze text for word count, reading time, complexity metrics, and readability scores.

## Features

- Word and character counting
- Reading time estimation (200-250 wpm)
- Complexity analysis (sentence structure, vocabulary)
- Readability scores (Flesch Reading Ease, grade level)
- Clear, actionable metrics

## When to Use

Perfect for:
- Document length analysis
- Reading time estimation
- Complexity assessment
- Readability evaluation
- Writing target validation

## Example Usage

**Input:** "How complex is this article?"

**Output:**
```
TEXT STATISTICS REPORT
=====================

Basic Metrics:
- Word Count: 847 (412 unique)
- Character Count: 5,234 (4,387 without spaces)
- Reading Time: 3-4 minutes

Complexity:
- Avg Sentence Length: 18 words
- Long Words (7+ chars): 23%
- Vocabulary Richness: 49%

Readability:
- Flesch Score: 62/100 (Standard)
- Grade Level: 8-9

Interpretation:
This text is moderately complex, appropriate for general adult readers.
Sentence variety is good. Vocabulary is reasonably accessible.
```

## Installation

1. Download `text-statistics-v1.0.0.skill`
2. Install in Claude Code or Claude web chat
3. Use when analyzing text documents

## Version

Current: v1.0.0

## License

MIT License - See LICENSE file
