# Cinematography Glossary for Veo 3.1

Complete reference of camera and cinematography terms that Veo 3.1 understands.

## Shot Sizes

| Term | Description | Use For |
|------|-------------|---------|
| **Extreme Wide Shot (EWS)** | Subject tiny in vast environment | Establishing location, epic scale |
| **Wide Shot (WS)** | Full body visible with environment | Scene context, character in setting |
| **Medium Wide Shot (MWS)** | Knees up | Walking scenes, group dynamics |
| **Medium Shot (MS)** | Waist up | Conversations, standard coverage |
| **Medium Close-Up (MCU)** | Chest up | Emotional moments, interviews |
| **Close-Up (CU)** | Face fills frame | Reactions, important details |
| **Extreme Close-Up (ECU)** | Single feature (eye, lips) | Intense emotion, tiny details |

## Shot Composition

| Term | Description | Use For |
|------|-------------|---------|
| **Single Shot** | One subject in frame | Solo focus, introspection |
| **Two Shot** | Two subjects in frame | Dialogue, relationships |
| **Three Shot** | Three subjects in frame | Group dynamics |
| **Over-the-Shoulder (OTS)** | Subject with back of another's shoulder | Dialogue perspective |
| **Point of View (POV)** | Camera as character's eyes | Immersion, first-person |
| **Insert Shot** | Detail of object or action | Emphasis, information |

## Camera Angles

| Term | Description | Effect |
|------|-------------|--------|
| **Eye Level** | Camera at subject's eye height | Neutral, natural |
| **High Angle** | Camera looks down on subject | Vulnerability, weakness |
| **Low Angle** | Camera looks up at subject | Power, dominance, heroism |
| **Bird's Eye** | Directly overhead | Detachment, overview |
| **Worm's Eye** | From ground looking up | Dramatic, imposing |
| **Dutch Angle/Tilt** | Camera tilted on axis | Unease, disorientation |

## Camera Movement

| Term | Description | Use For |
|------|-------------|---------|
| **Static Shot** | Camera doesn't move | Stability, observation |
| **Pan** | Camera rotates horizontally (left/right) | Following action, revealing space |
| **Tilt** | Camera rotates vertically (up/down) | Revealing height, reactions |
| **Dolly In** | Camera moves toward subject | Building intensity, intimacy |
| **Dolly Out** | Camera moves away from subject | Revealing context, isolation |
| **Tracking Shot** | Camera moves alongside subject | Following movement |
| **Crane Shot** | Camera moves vertically on crane | Sweeping reveals, scale |
| **Steadicam** | Smooth handheld movement | Fluid following shots |
| **Handheld** | Intentionally shaky movement | Urgency, documentary feel |
| **Zoom** | Lens adjusts focal length | Emphasis without moving camera |
| **Push In** | Subtle move toward subject | Drawing attention |
| **Pull Back** | Subtle move away from subject | Revealing context |
| **Arc Shot** | Camera moves in circular path | Dynamic perspective shift |
| **Aerial Shot** | Camera from above, often drone | Establishing, scope |

## Focus Techniques

| Term | Description | Effect |
|------|-------------|--------|
| **Shallow Focus** | Only subject sharp, background blurred | Isolation, attention |
| **Deep Focus** | Everything sharp from foreground to background | Context, environment |
| **Rack Focus** | Focus shifts from one subject to another | Directing attention |
| **Soft Focus** | Intentionally slightly blurred | Dreamy, romantic |
| **Split Diopter** | Two planes in focus simultaneously | Tension, duality |

## Lens Types

| Term | Description | Effect |
|------|-------------|--------|
| **Wide-Angle Lens** | Broad field of view (14-35mm) | Environment emphasis, distortion |
| **Normal Lens** | Natural perspective (35-50mm) | Realistic, documentary |
| **Telephoto Lens** | Narrow field, compressed space (70-200mm+) | Intimacy, flattened depth |
| **Macro Lens** | Extreme close-up capability | Tiny details, insects, textures |
| **Anamorphic Lens** | Cinematic wide aspect, distinctive flares | Hollywood look, scope |

## Lighting Terms

| Term | Description | Mood |
|------|-------------|------|
| **High Key** | Bright, even lighting, few shadows | Happy, upbeat, comedy |
| **Low Key** | Dark with strong shadows | Drama, noir, suspense |
| **Chiaroscuro** | Strong contrast between light and dark | Dramatic, artistic |
| **Golden Hour** | Warm light just after sunrise/before sunset | Romantic, nostalgic |
| **Blue Hour** | Cool light just before sunrise/after sunset | Melancholy, calm |
| **Practical Lighting** | Light sources visible in scene (lamps, etc.) | Realism, atmosphere |
| **Backlit/Silhouette** | Light behind subject | Mystery, drama |
| **Rim Light** | Light outlining subject's edge | Separation, drama |
| **Soft Light** | Diffused, gentle shadows | Flattering, romantic |
| **Hard Light** | Sharp, defined shadows | Harsh, dramatic |

## Transitions

| Term | Description | Use For |
|------|-------------|---------|
| **Cut** | Instant change between shots | Standard editing |
| **Dissolve** | One shot fades into another | Time passage, dreamy |
| **Fade In/Out** | From/to black or white | Scene beginnings/endings |
| **Wipe** | New shot pushes old shot off screen | Stylized, retro |
| **Match Cut** | Visual or action similarity between shots | Narrative connection |

## Prompt Examples Using Terms

**Action Sequence:**
> "Tracking shot following a runner through city streets, low angle, wide-angle lens, handheld for energy, golden hour light"

**Emotional Moment:**
> "Slow dolly-in to extreme close-up of tear rolling down cheek, shallow focus, soft backlighting, melancholy mood"

**Establishing Shot:**
> "Bird's eye extreme wide shot of Manhattan skyline at dusk, aerial perspective, deep focus, blue hour lighting"

**Dialogue Scene:**
> "Medium over-the-shoulder shot, eye level, soft lighting, shallow depth of field isolating speaker"

**Dramatic Reveal:**
> "Slow crane shot rising to reveal massive spaceship behind mountains, wide-angle lens, epic scale, dramatic sunset backlighting"
