# Commit Message Examples

## Conventional Commits

### Features
```
feat(api): add user registration endpoint
feat(ui): implement dark mode toggle
feat(auth): add OAuth2 Google provider
```

### Fixes
```
fix(api): return 404 for missing resources
fix(ui): correct button alignment on mobile
fix(auth): handle expired refresh tokens
```

### Documentation
```
docs(api): add OpenAPI specification
docs(readme): update quick start guide
docs(contributing): add PR template
```

### Refactoring
```
refactor(api): extract validation logic
refactor(db): optimize user queries
refactor(auth): simplify token refresh flow
```

### Tests
```
test(api): add integration tests for /users
test(auth): cover edge cases in token validation
test(ui): add snapshot tests for components
```

### Chores
```
chore(deps): update pytest to 7.4.0
chore(ci): add GitHub Actions workflow
chore(docker): optimize image size
```

## Multi-line Commits

For complex changes, add a body:

```
feat(api): implement rate limiting

Add sliding window rate limiter with Redis backend.
Default: 100 requests per minute per IP.

Closes #123
```

## What to Avoid

- `fix stuff` (too vague)
- `WIP` (don't commit work in progress)
- `asdfasdf` (meaningless)
- Messages over 72 characters on first line
