#!/bin/bash
# plan-check.sh - Validate and plan Terraform changes
# Returns: 0 if valid, 1 if errors

set -e

echo "=== Terraform Pre-flight Check ==="

# Check if initialized
if [ ! -d ".terraform" ]; then
    echo "Running terraform init..."
    terraform init
fi

# Validate
echo "Validating configuration..."
if ! terraform validate; then
    echo "ERROR: Validation failed"
    exit 1
fi

# Format check
echo "Checking formatting..."
if ! terraform fmt -check -recursive; then
    echo "WARNING: Files need formatting (run: terraform fmt -recursive)"
fi

# TFLint if available
if command -v tflint &> /dev/null; then
    echo "Running tflint..."
    tflint --recursive || echo "WARNING: tflint found issues"
fi

# Plan
echo "Creating plan..."
terraform plan -out=tfplan

echo ""
echo "=== Plan complete ==="
echo "Review the plan above."
echo "To apply: terraform apply tfplan"
echo ""
