# Ask Patterns

## Requires User Confirmation

### Network Operations

- `WebFetch(domain:*)` - Any external network request
- `curl`, `wget` - Command-line network requests
- API calls to external services

### Git Operations

- `git push` - Pushing to remote
- `git merge` - Merging branches
- `git rebase` - Rewriting history
- `git reset --hard` - Destructive reset

### Infrastructure Operations

- `terraform plan` - Show planned changes
- `terraform apply` - Apply with confirmation
- `terragrunt plan` - Show planned changes
- `terragrunt apply` - Apply with confirmation
- `kubectl apply` - After showing diff
- `ansible-playbook --check` - Dry run first

### Package Operations

- `pip install` (new packages)
- `npm install` (new packages)
- `cargo add` (new packages)

## Confirmation Format

Before executing, state:

1. What operation you're about to perform
2. What will be affected
3. Ask: "Proceed? (yes/no)"

Wait for explicit "yes" before continuing.
