# Blocked Patterns

## File Patterns (DENY)

Never read, write, or access:

| Pattern | Reason |
|---------|--------|
| `.env` | Environment secrets |
| `.env.*` | Environment variants |
| `*.pem` | Private keys |
| `*.key` | Private keys |
| `*secret*` | Secrets by name |
| `*credential*` | Credentials by name |
| `*password*` | Passwords by name |
| `*token*` | API tokens |
| `.aws/*` | AWS credentials |
| `.ssh/*` | SSH keys |
| `.gcp/*` | GCP credentials |
| `.azure/*` | Azure credentials |
| `*kubeconfig*` | Kubernetes auth |
| `.npmrc` | npm tokens |
| `.pypirc` | PyPI tokens |
| `.netrc` | Network credentials |
| `id_rsa*` | SSH private keys |
| `id_ed25519*` | SSH private keys |

## Command Patterns (DENY)

Never execute without explicit request:

| Command | Reason |
|---------|--------|
| `terraform apply` | Destructive infrastructure |
| `terraform destroy` | Destructive infrastructure |
| `terragrunt apply` | Destructive infrastructure |
| `terragrunt destroy` | Destructive infrastructure |
| `kubectl apply` | Cluster modification |
| `kubectl delete` | Cluster modification |
| `ansible-playbook` (without --check) | System modification |
| `rm -rf` | Destructive deletion |
| `chmod 777` | Security risk |
| Any command with secrets/tokens in args | Credential exposure |
