#!/bin/bash
# gate-status.sh - Check TDD gate configuration
# Reads from ~/.claude/.forge-answers or defaults to soft

ANSWERS_FILE="$HOME/.claude/.forge-answers"

if [ -f "$ANSWERS_FILE" ]; then
    GATE=$(grep "^TDD_GATE=" "$ANSWERS_FILE" | cut -d'=' -f2)
else
    GATE="soft"
fi

echo "TDD Gate: $GATE"

if [ "$GATE" = "hard" ]; then
    echo "Status: ENFORCING - Tests must pass before any commit"
    echo "Action: Fix failing tests before proceeding"
else
    echo "Status: ADVISORY - Warnings shown but not blocking"
    echo "Action: Tests recommended but not required"
fi
