---
name: design-thinking
description: Design Thinking methodology for human-centered innovation. Covers the 5-phase IDEO/Stanford d.school approach (Empathize, Define, Ideate, Prototype, Test) with workshop facilitation and exercise templates.
allowed-tools: Read, Glob, Grep, Task, Skill
---

# Design Thinking

## When to Use This Skill

Use this skill when:

- **Design Thinking tasks** - Working on design thinking methodology for human-centered innovation. covers the 5-phase ideo/stanford d.school approach (empathize, define, ideate, prototype, test) with workshop facilitation and exercise templates
- **Planning or design** - Need guidance on Design Thinking approaches
- **Best practices** - Want to follow established patterns and standards

## Overview

A human-centered approach to innovation that integrates the needs of people, the possibilities of technology, and the requirements for business success.

## What is Design Thinking?

Design Thinking is a problem-solving methodology developed by IDEO and taught at Stanford d.school. It emphasizes understanding users, challenging assumptions, redefining problems, and creating innovative solutions through iterative prototyping and testing.

### Core Principles

| Principle | Description |
|-----------|-------------|
| **Human-Centered** | Start with people, not technology or process |
| **Embrace Ambiguity** | Comfortable with uncertainty early on |
| **Bias to Action** | Learn by doing, not just thinking |
| **Radical Collaboration** | Cross-functional, diverse perspectives |
| **Iterate Rapidly** | Fail fast, learn fast, improve fast |

## The 5 Phases

```text
┌─────────┐  ┌─────────┐  ┌─────────┐  ┌─────────┐  ┌─────────┐
│         │  │         │  │         │  │         │  │         │
│EMPATHIZE│→│ DEFINE  │→│ IDEATE  │→│PROTOTYPE│→│  TEST   │
│         │  │         │  │         │  │         │  │         │
│Understand│  │Frame the│  │Generate │  │Build to │  │Learn &  │
│the user │  │problem  │  │ideas    │  │learn    │  │refine   │
└─────────┘  └─────────┘  └─────────┘  └─────────┘  └─────────┘
     ▲                                                    │
     └────────────────── Iterate ─────────────────────────┘
```

### Phase Characteristics

| Phase | Mode | Key Question | Output |
|-------|------|--------------|--------|
| **Empathize** | Diverge | What is the user experiencing? | Insights, observations |
| **Define** | Converge | What is the core problem? | POV statement |
| **Ideate** | Diverge | What are possible solutions? | Ideas, concepts |
| **Prototype** | Converge | How can we make it tangible? | Prototypes |
| **Test** | Learn | What works and what doesn't? | Validated learning |

## Phase 1: Empathize

Build deep understanding of users and their experiences.

### Empathy Methods

| Method | Duration | Participants | Best For |
|--------|----------|--------------|----------|
| **User Interviews** | 30-60 min | 1:1 | Deep individual insight |
| **Observation** | Hours-days | Field work | Natural behavior |
| **Empathy Mapping** | 15-30 min | Workshop | Synthesizing research |
| **Journey Mapping** | 1-2 hours | Workshop | Experience visualization |
| **Shadowing** | Half-day | Field work | Workflow understanding |

### Empathy Map Template

```markdown
## Empathy Map: [User/Persona Name]

### Says
[Direct quotes from interviews/observation]
- "[Quote 1]"
- "[Quote 2]"

### Thinks
[What might they be thinking? Hopes/fears?]
- [Thought 1]
- [Thought 2]

### Does
[Actions and behaviors observed]
- [Behavior 1]
- [Behavior 2]

### Feels
[Emotional state, what worries/excites them]
- [Emotion 1]
- [Emotion 2]

### Pains
[Frustrations, obstacles, risks]
- [Pain 1]
- [Pain 2]

### Gains
[Wants, needs, measures of success]
- [Gain 1]
- [Gain 2]
```

### Interview Guide Structure

```markdown
## User Interview Guide

**Duration:** 45-60 minutes
**Objective:** [What we want to learn]

### Opening (5 min)
- Introduce yourself and purpose
- Explain confidentiality, recording consent
- "There are no right or wrong answers"

### Context (10 min)
- Tell me about your role/day-to-day
- How long have you been doing [X]?
- Walk me through a typical [scenario]

### Deep Dive (25 min)
- Tell me about a time when [specific experience]
- What was the most challenging part?
- What did you try? What happened?
- How did that make you feel?

### Needs & Desires (10 min)
- If you could wave a magic wand, what would change?
- What would that enable you to do?
- What does success look like for you?

### Closing (5 min)
- Is there anything else you'd like to share?
- Can we follow up if we have questions?
```

## Phase 2: Define

Synthesize observations and frame the right problem.

### Point of View (POV) Statement

```markdown
## POV Statement

**User:** [Specific user type/persona]

**Need:** [Verb - what they need to do]

**Insight:** [Because - surprising insight about why]

---

**Full Statement:**
[User] needs to [need] because [insight].

**Example:**
A busy working parent needs to quickly prepare healthy meals
because they want to model good eating habits for their children
but feel guilty about the time-cost tradeoff.
```

### How Might We (HMW) Questions

Transform POV into actionable opportunity statements:

```markdown
## How Might We Questions

**POV:** [Your POV statement]

### HMW Brainstorm

Generate HMW questions by asking:

| Lens | Question | HMW |
|------|----------|-----|
| **Amplify the good** | What's working? | HMW do more of [good thing]? |
| **Remove the bad** | What's painful? | HMW eliminate [pain point]? |
| **Explore the opposite** | What if we flipped it? | HMW [opposite approach]? |
| **Question assumptions** | What's assumed? | HMW if [assumption] wasn't true? |
| **Change status quo** | What's expected? | HMW change when/where/who? |
| **Break it into parts** | What are components? | HMW address just [component]? |

### Selected HMW Questions
1. HMW [question 1]?
2. HMW [question 2]?
3. HMW [question 3]?

**Priority HMW:** [The one to ideate on]
```

## Phase 3: Ideate

Generate a wide range of creative solutions.

### Ideation Rules

| Rule | Description |
|------|-------------|
| **Defer judgment** | No criticism during brainstorming |
| **Go for quantity** | More ideas = better ideas |
| **Build on others' ideas** | "Yes, and..." |
| **Encourage wild ideas** | Think big, no constraints |
| **Be visual** | Sketch, don't just talk |
| **One conversation** | Listen, build, riff |
| **Stay focused** | Keep the HMW visible |

### Brainstorming Session Template

```markdown
## Ideation Session

**HMW:** [The How Might We question]
**Duration:** 30-45 minutes
**Participants:** [Names]

### Warm-Up (5 min)
[Quick creative exercise to loosen up]

### Silent Brainstorm (10 min)
- Write one idea per sticky note
- Work individually
- Aim for 10+ ideas each

### Share & Build (15 min)
- Share ideas one by one
- Build on others' ideas
- No criticism, only "Yes, and..."

### Cluster & Theme (10 min)
- Group similar ideas
- Name each cluster
- Identify promising directions

### Ideas Generated
| Cluster | Ideas | Count |
|---------|-------|-------|
| [Theme 1] | [List] | [N] |
| [Theme 2] | [List] | [N] |

### Top Ideas to Prototype
1. [Idea 1]
2. [Idea 2]
3. [Idea 3]
```

### Ideation Techniques

| Technique | Description | When to Use |
|-----------|-------------|-------------|
| **Classic Brainstorm** | Free association | Starting point |
| **Brainwriting** | Silent written ideas | Quiet/remote groups |
| **SCAMPER** | Substitute, Combine, Adapt, Modify, Put to other use, Eliminate, Reverse | Improving existing |
| **Analogies** | How would X solve this? | Breaking mental models |
| **Worst Idea** | Intentionally bad ideas | When stuck |
| **Mash-up** | Combine unrelated concepts | Radical innovation |

## Phase 4: Prototype

Build quick, cheap representations to learn.

### Prototype Philosophy

> "If a picture is worth 1,000 words, a prototype is worth 1,000 meetings."
> — IDEO

### Prototype Types

| Type | Fidelity | Time | Best For |
|------|----------|------|----------|
| **Paper Sketch** | Very Low | Minutes | Earliest exploration |
| **Storyboard** | Low | 30 min | User journey, scenarios |
| **Paper Prototype** | Low | 1-2 hours | Screen flows, UI |
| **Role Play** | Low | 30 min | Service experiences |
| **Wizard of Oz** | Medium | Hours | Complex interactions |
| **Clickable Mockup** | Medium | Days | Digital products |
| **Physical Model** | Varies | Varies | Tangible products |

### Prototype Planning Template

```markdown
## Prototype Plan

**Concept:** [What we're prototyping]
**Goal:** [What we want to learn]
**Audience:** [Who will test it]

### What to Prototype
- **Include:** [Essential elements to test]
- **Exclude:** [What we won't build yet]

### Prototype Type
**Type:** [Paper/Digital/Physical/Role-play]
**Fidelity:** [Low/Medium/High]
**Time to Build:** [Duration]

### Materials Needed
- [Material 1]
- [Material 2]

### Key Questions to Answer
1. [Question 1]
2. [Question 2]
3. [Question 3]

### Success Criteria
- [How we'll know it worked]
```

### Storyboard Template

```markdown
## Storyboard: [Concept Name]

### Scene 1: [Setup]
[Sketch/Description]
**What's happening:** [Action]
**User says/thinks:** "[Quote]"

### Scene 2: [Trigger]
[Sketch/Description]
**What's happening:** [Action]
**User says/thinks:** "[Quote]"

### Scene 3: [Interaction]
[Sketch/Description]
**What's happening:** [Action]
**User says/thinks:** "[Quote]"

### Scene 4: [Resolution]
[Sketch/Description]
**What's happening:** [Action]
**User says/thinks:** "[Quote]"
```

## Phase 5: Test

Learn what works, what doesn't, and iterate.

### Testing Principles

| Principle | Description |
|-----------|-------------|
| **Show, don't tell** | Let the prototype speak |
| **Create experiences** | Have users interact, not just look |
| **Ask "why?"** | Dig into reactions |
| **Embrace failure** | Every test teaches something |
| **Iterate** | Build-test-learn cycles |

### Test Session Template

```markdown
## Test Session

**Prototype:** [Name/Version]
**Participant:** [Code or name]
**Date:** [ISO date]

### Introduction
"We're testing a concept, not you. There are no wrong answers.
Please think out loud as you interact with this."

### Scenario
[Context to set up the test]

### Observations

| Moment | Observation | Quote | Insight |
|--------|-------------|-------|---------|
| [When] | [What happened] | "[Said]" | [Meaning] |

### Key Learnings
1. [Learning 1]
2. [Learning 2]
3. [Learning 3]

### What to Keep
- [Element that worked]

### What to Change
- [Element to modify]

### Questions Raised
- [New question to explore]
```

### Iteration Framework

```markdown
## Iteration Review

**Prototype Version:** [N]
**Tests Conducted:** [Number]

### Synthesis

| Finding | Frequency | Severity | Action |
|---------|-----------|----------|--------|
| [Finding] | [X/N] | H/M/L | Keep/Change/Remove |

### Next Iteration

**Priority Changes:**
1. [Change 1]
2. [Change 2]

**Hypothesis to Test:**
If we [change], then [expected outcome] because [reason].
```

## Workshop Agenda Templates

### Half-Day Workshop (4 hours)

```markdown
## Design Thinking Workshop

**Duration:** 4 hours
**Participants:** 6-12 people

### Agenda

**0:00 - 0:15** Welcome & Icebreaker
- Introductions
- Creative warm-up

**0:15 - 0:45** Empathy Share (30 min)
- Share research/interviews
- Empathy mapping exercise

**0:45 - 1:15** Define (30 min)
- Synthesize insights
- Create POV statements
- Generate HMW questions

**1:15 - 1:30** Break (15 min)

**1:30 - 2:15** Ideate (45 min)
- Brainstorming
- Clustering
- Voting

**2:15 - 3:15** Prototype (60 min)
- Teams build low-fi prototypes
- Prepare to present

**3:15 - 3:45** Share & Feedback (30 min)
- Each team presents
- Group feedback

**3:45 - 4:00** Wrap-up (15 min)
- Key decisions
- Next steps
```

### Full-Day Sprint (8 hours)

```markdown
## Design Sprint (1-Day)

**Duration:** 8 hours (condensed from 5-day sprint)
**Participants:** 5-8 people cross-functional

### Morning: Understand & Define

**9:00 - 9:30** Set the stage
- Sprint goal
- Challenge statement

**9:30 - 10:30** Expert interviews / Lightning talks
- Stakeholder perspectives
- User insights

**10:30 - 11:00** How Might We
- Generate HMW from insights
- Vote on priority

**11:00 - 12:00** Sketch solutions
- Individual crazy 8s
- Solution sketches

### Afternoon: Build & Test

**12:00 - 1:00** Lunch

**1:00 - 1:30** Decide
- Critique sketches
- Vote
- Decide what to prototype

**1:30 - 4:00** Prototype
- Build testable prototype
- Prepare test script

**4:00 - 5:00** Test
- 3-5 user tests
- Capture feedback

**5:00 - 5:30** Debrief
- What we learned
- Next steps
```

## Integration with Other Methods

### Upstream

- **User Research** - Feeds into Empathize phase
- **Stakeholder Analysis** - Identifies who to interview
- **Strategic Analysis** - Business context for innovation

### Downstream

- **Lean Startup** - Build-Measure-Learn loops
- **Agile Development** - Iterative implementation
- **Business Model Canvas** - Modeling the solution

## .NET/C# Context

When applying Design Thinking to software products:

```csharp
// Example: Tracking Design Thinking sessions
public class DesignThinkingSession
{
    public Guid Id { get; init; }
    public required string ChallengeName { get; init; }
    public required DesignPhase CurrentPhase { get; init; }
    public required string HowMightWe { get; init; }
    public DateTimeOffset Created { get; init; }

    public List<EmpathyInsight> Insights { get; } = [];
    public PointOfView? Pov { get; set; }
    public List<Idea> Ideas { get; } = [];
    public List<Prototype> Prototypes { get; } = [];
    public List<TestResult> Tests { get; } = [];
}

public enum DesignPhase
{
    Empathize,
    Define,
    Ideate,
    Prototype,
    Test
}

public record EmpathyInsight(
    string Observation,
    string UserQuote,
    string Interpretation
);

public record PointOfView(
    string User,
    string Need,
    string Insight
);

public record Idea(
    string Title,
    string Description,
    int Votes,
    string Cluster
);
```

## Related Skills

- `stakeholder-analysis` - Identifying interview subjects
- `journey-mapping` - Empathize phase visualization
- `business-model-canvas` - Modeling solutions
- `prioritization` - Selecting which ideas to prototype

## Version History

- **v1.0.0** (2025-12-26): Initial release
