# Known Claude Code Performance Issues

## Overview

This document tracks known performance issues in Claude Code from GitHub issues and community reports. Updated as of December 2025.

## Critical Issues

### #10881: Performance Degrades in Long Sessions

**Status:** OPEN

**Description:**
Claude Code "consistently degrades in performance over long sessions." After several auto-compacts or extended use, performance becomes "terrible" with multi-minute latencies between requests.

**Symptoms:**

- Responses take 30+ seconds
- Input lag becomes noticeable
- Context recall degrades
- Auto-compact triggers repeatedly

**Root Cause Theories:**

- Internal data structures accumulate
- Memory leak in session management
- Context operations become expensive
- Garbage collection overhead

**Workaround:**

```text
1. Save current state to file
2. Exit Claude Code
3. Start fresh session
4. Resume from saved state
```

**Best Practice:** Restart Claude Code every 2-4 hours during heavy use.

---

### #14552: CLI Input Lag with High Context

**Status:** OPEN

**Description:**
After ~30+ interactions with ~64% context usage (128k/200k tokens), typing becomes slow with noticeable delay.

**Symptoms:**

- Keyboard input lags
- Characters appear delayed
- Backspace/delete slow
- Terminal feels unresponsive

**Pattern:**
Performance degradation correlates with:

- Context window fill percentage (not absolute count)
- Worse above 64% usage
- Critical above 85%

**Workaround:**

```text
1. Run /clear to reset context
2. Or run /compact for partial reset
3. Monitor context usage proactively
```

---

### #14476: Performance Regression in v2.0.72

**Status:** RESOLVED (in later versions)

**Description:**
Performance regression even at ~30k tokens (not just 100k+). Suggests issues with rendering/processing, not just raw token count.

**Workaround:**

- Update to latest Claude Code version
- Check `claude --version`
- Update with: `npm install -g @anthropic-ai/claude-code`

---

### #1497: Keyboard Responsiveness Degradation

**Status:** PARTIALLY ADDRESSED

**Description:**
Keyboard input becomes "laggier and jankier" over time. Delete key can stop working for 30 seconds while typing works intermittently.

**Root Cause:**
Likely rendering pipeline or event loop blocking as context grows.

**Recent Fixes:**
"Fixed slow input history cycling and race condition that could overwrite text after message submission" - December 2025 update

**Workaround:**

- Keep Claude Code updated
- Restart when symptoms appear
- Use /clear proactively

---

### #2350: XDG Base Directory Non-Compliance

**Status:** OPEN

**Description:**
Claude Code stores ALL files in `~/.claude/`, violating XDG Base Directory Specification which should separate config, cache, and data.

**Impact:**

- Can slow directory operations
- Complicates backup/sync strategies
- Not standard Unix behavior

**Current Reality:**
No workaround - awaiting fix from Anthropic.

---

## Version-Specific Issues

### v2.0.61 - Extreme Slowness

**Status:** RESOLVED

**Issue #13466:** "Extremely slow" performance with "excessive token consumption."

**Resolution:** Fixed in later versions. Update to latest.

---

## Monitoring for New Issues

### Where to Check

1. GitHub Issues: <https://github.com/anthropics/claude-code/issues>
2. Status Page: <https://status.anthropic.com>
3. Community: Reddit, Discord, Twitter

### Search Terms

- "slow" OR "performance"
- "lag" OR "delay"
- "context" AND "degradation"
- "memory" AND "leak"

### Use the Agent

```text
/diagnose-performance
```

This command spawns the performance-diagnostician agent which searches for recent issues.

---

## Issue Reporting

If you encounter a new issue:

1. **Check existing issues** - May already be reported
2. **Gather diagnostics:**
   - Claude Code version (`claude --version`)
   - OS and version
   - Session length
   - Context size (if known)
   - Steps to reproduce
3. **File at:** <https://github.com/anthropics/claude-code/issues/new>

---

## Historical Issues (Resolved)

| Issue | Description | Resolution |
|-------|-------------|------------|
| Infrastructure bugs (Aug-Sep 2025) | Context routing errors, TPU issues | Fixed by Anthropic |
| Token overconsumption | Excessive token usage | Addressed in updates |
| Auto-compact failures | Compaction running too late | Threshold adjusted earlier |

---

## Summary Table

| Issue | Status | Impact | Workaround |
|-------|--------|--------|------------|
| #10881 | OPEN | High | Restart periodically |
| #14552 | OPEN | High | /clear at 64%+ |
| #14476 | RESOLVED | Medium | Update version |
| #1497 | PARTIAL | Medium | Keep updated, restart |
| #2350 | OPEN | Low | None (awaiting fix) |

---

## Last Updated

**Date:** 2025-12-26
**Sources:** GitHub Issues, Anthropic Engineering Blog, Community Reports
