---
source_url: https://cursor.com/docs/cli/github-actions.md
source_type: llms-txt
content_hash: sha256:adf2138cf1e00352da0e9bd7e0d5e24b646e211f721c29d82c2fed8cd5592a3c
sitemap_url: https://cursor.com/llms.txt
fetch_method: html
---

export const meta = {
title: "GitHub Actions",
description: "Integrate Cursor CLI with GitHub Actions for automated code reviews and AI-powered CI/CD workflows. Set up authentication and usage limits."
};
# GitHub Actions
Use Cursor CLI in GitHub Actions and other CI/CD systems to automate development tasks.
## GitHub Actions integration
Basic setup:
```yaml
- name: Install Cursor CLI
run: |
curl https://cursor.com/install -fsS | bash
echo "$HOME/.cursor/bin" >> $GITHUB\_PATH
- name: Run Cursor Agent
env:
CURSOR\_API\_KEY: ${{ secrets.CURSOR\_API\_KEY }}
run: |
agent -p "Your prompt here" --model gpt-5
```
## Cookbook examples
See our cookbook examples for practical workflows: [updating documentation](/docs/cli/cookbook/update-docs) and [fixing CI issues](/docs/cli/cookbook/fix-ci).
## Other CI systems
Use Cursor CLI in any CI/CD system with:
- \*\*Shell script execution\*\* (bash, zsh, etc.)
- \*\*Environment variables\*\* for API key configuration
- \*\*Internet connectivity\*\* to reach Cursor's API
## Autonomy levels
Choose your agent's autonomy level:
### Full autonomy approach
Give the agent complete control over git operations, API calls, and external interactions. Simpler setup, requires more trust.
\*\*Example:\*\* In our [Update Documentation](/docs/cli/cookbook/update-docs) cookbook, the first workflow lets the agent:
- Analyze PR changes
- Create and manage git branches
- Commit and push changes
- Post comments on pull requests
- Handle all error scenarios
```yaml
- name: Update docs (full autonomy)
run: |
agent -p "You have full access to git, GitHub CLI, and PR operations.
Handle the entire docs update workflow including commits, pushes, and PR comments."
```
### Restricted autonomy approach
We recommend using this approach with \*\*permission-based restrictions\*\* for
production CI workflows. This gives you the best of both worlds: the agent can
intelligently handle complex analysis and file modifications while critical
operations remain deterministic and auditable.
Limit agent operations while handling critical steps in separate workflow steps. Better control and predictability.
\*\*Example:\*\* The second workflow in the same cookbook restricts the agent to only file modifications:
```yaml
- name: Generate docs updates (restricted)
run: |
agent -p "IMPORTANT: Do NOT create branches, commit, push, or post PR comments.
Only modify files in the working directory. A later workflow step handles publishing."
- name: Publish docs branch (deterministic)
run: |
# Deterministic git operations handled by CI
git checkout -B "docs/${{ github.head\_ref }}"
git add -A
git commit -m "docs: update for PR"
git push origin "docs/${{ github.head\_ref }}"
- name: Post PR comment (deterministic)
run: |
# Deterministic PR commenting handled by CI
gh pr comment ${{ github.event.pull\_request.number }} --body "Docs updated"
```
### Permission-based restrictions
Use [permission configurations](/docs/cli/reference/permissions) to enforce restrictions at the CLI level:
```json
{
"permissions": {
"allow": [
"Read(\*\*/\*.md)",
"Write(docs/\*\*/\*)",
"Shell(grep)",
"Shell(find)"
],
"deny": ["Shell(git)", "Shell(gh)", "Write(.env\*)", "Write(package.json)"]
}
}
```
## Authentication
### Generate your API key
First, [generate an API key](/docs/cli/reference/authentication#api-key-authentication) from your Cursor dashboard.
### Configure repository secrets
Store your Cursor API key securely in your repository using the GitHub CLI:
```bash
# Repository secret
gh secret set CURSOR\_API\_KEY --repo OWNER/REPO --body "$CURSOR\_API\_KEY"
# Organization secret (all repos)
gh secret set CURSOR\_API\_KEY --org ORG --visibility all --body "$CURSOR\_API\_KEY"
```
Alternatively, use the GitHub UI: Go to your repository → \*\*Settings\*\* → \*\*Secrets and variables\*\* → \*\*Actions\*\* → \*\*New repository secret\*\*
### Use in workflows
Set your `CURSOR\_API\_KEY` environment variable:
```yaml
env:
CURSOR\_API\_KEY: ${{ secrets.CURSOR\_API\_KEY }}
```
---
## Sitemap
[Overview of all docs pages](/llms.txt)
