---
source_url: https://cursor.com/docs/cli/installation.md
source_type: llms-txt
content_hash: sha256:5305970a436947bc7b2b2e2eb23dda20a9e2bcc024fcf63c989f0ea949762eee
sitemap_url: https://cursor.com/llms.txt
fetch_method: html
---

export const meta = {
title: "Installation",
description: "Install Cursor CLI on macOS, Linux, and Windows with a single command. Verify installation and configure PATH for optimal setup."
};
# Installation
## Installation
### macOS, Linux and Windows (WSL)
Install Cursor CLI with a single command:
```bash
curl https://cursor.com/install -fsS | bash
```
### Verification
After installation, verify that Cursor CLI is working correctly:
```bash
agent --version
```
## Post-installation setup
1. \*\*Add ~/.local/bin to your PATH:\*\*
For bash:
```bash
echo 'export PATH="$HOME/.local/bin:$PATH"' >> ~/.bashrc
source ~/.bashrc
```
For zsh:
```bash
echo 'export PATH="$HOME/.local/bin:$PATH"' >> ~/.zshrc
source ~/.zshrc
```
2. \*\*Start using Cursor Agent:\*\*
```bash
agent
```
## Updates
Cursor CLI will try to auto-update by default to ensure you always have the latest version.
To manually update Cursor CLI to the latest version:
```bash
agent update
# or
agent upgrade
```
Both commands will update Cursor Agent to the latest version.
---
## Sitemap
[Overview of all docs pages](/llms.txt)
